title: Shock Stabilization Test Case

This 2D Euler setup simulates a planar shock travelling in positive y direction
through the domain.
It makes use of a covolume filter with some weak spectral filtering, to overcome
oscillation residues at element boundaries after the shock passed them.
In the time discretization a Taylor Runge-Kutta scheme is employed, that allows
for an arbitrary number of stages.

The complete configuration is provided in the `ateles.lua` file:

```lua
{!examples/euler/2D/shock_stabilization_parallel/ateles.lua!}
```

**Features used**

1. Projection: fpt, Oversampling 2

2. Polynomial representation: Q

3. Filtering: covolume, spectral

4. Timestepping: explicitRungeKuttaTaylor, 4 steps

5. Boundary conditions: `slipwall`, `inflow_normal`, `outflow`
