title: Build and run Musubi

Subsequently is a short explanation on how to use Musubi:

- Checkout: 
    - <tt>hg clone https://geb.sts.nt.uni-siegen.de/hg/musubi</tt>
  
  then you have the repository with sub-repos aotus and treelm in the folder <tt>musubi</tt>.
- Note: You need MPI in order to compile the code. 

- Set environment variables
    - <tt>export CC=mpicc</tt>
    - <tt>export FC=mpif90</tt>
- Configure
    - <tt>./waf configure</tt>
- Build 
    - <tt>./waf build</tt>
- Change settings in <tt>musubi.lua</tt>
- Run 
    - <tt>./build/musubi</tt>

You will get .vtk files, if you have activated the output in
<tt>musubi.lua</tt>.  The current test case is a Gaussian Pulse with a wall in
order to test the correct behavior of the bounce back boundaries.

# Generate a geometry 

A different geometry can be generated with the tree-based Mesh generator Seeder.

## Build and run Seeder 

- Checkout: <tt>hg clone https://geb.sts.nt.uni-siegen.de/hg/seeder</tt>
  then you have the repository with sub-repos aotus and treelm in the folder <tt>seeder</tt>.
- Note: You need MPI in order to compile the code. 

Set environment variables 
<tt>export CC=mpicc</tt>
<tt>export FC=mpif90</tt>

- Configure <tt>./waf configure</tt>
- Build <tt>./waf build</tt>
- Generate mesh folder in current folder: <tt>mkdir ./mesh</tt>
- Change settings in <tt>input/config.lua</tt>. Specify the STL file(s) and set the min and max tree levels. 
  Note: In the current version, Musubi only supports uniform grids, which can be generated by setting <tt>maxrefine = minrefine</tt>.
- Run <tt>./build/seeder input/config.lua</tt>
- Generated mesh is in the <tt>mesh/</tt> folder
- Copy all files from <tt>mesh</tt> to the musubi mesh folder <tt>../musubi/mesh</tt>

You will receive a VTK file, in order to check the fluid domain. The fluid is
identified by placing the seed in the correct position in seeder.f90, which
will be changed later. A good start is in the first position, just make sure
that it is part of the continuous fluid domain.


The parallel version has not been tackled yet but has a high priority on our task-list.
The next step will be parallel functionality and inlet/outlet boundaries.

Please make sure to check out musubi and start a few runs.
Please also report any bugs here in the tickets.

@note After updating a new version of Musubi you better do <tt>./waf configure build</tt>.
Sometimes you need to clean the coco macro files. Then you do <tt>./waf clean build</tt>.
To remove the source and the configuration files you type <tt>./waf distclean configure build</tt>.
And if you want to remove the coco executables itself you will type <tt>./waf cleanall configure build</tt>.
If you do not want to affect coco you will add <tt>--target=musubi</tt> after the <tt>build</tt> command.
