#include <stdio.h>
#include <string.h>
#include <math.h>
#include <gsl/gsl_statistics_double.h>
#include <gsl/gsl_fit.h>
#include "chk.h"

typedef struct {
	size_t max_str;
	size_t max_filename;
	size_t dat_num;
	char *file;
	double *x;
	double *y;
} param;

param *param_alloc(void);
void param_init(param *);
void param_free(param *);
void param_print(param *);

param *param_alloc()
{
	return (param *) chk_calloc(1, sizeof(param));
}

void param_init(p)
param *p;
{
	int max_str;
	FILE *fp;
	char *str;
	size_t i = 0;
	p->max_filename = 100;
	p->max_str = 100;
	p->file = (char *) chk_calloc(p->max_filename, sizeof(char));
	str = (char *) chk_calloc(p->max_str, sizeof(char));
	max_str = (int) p->max_str;
	strcpy(p->file, "tmp/dlacluster.stdout");
	fp = fopen(p->file, "r");
	if (fp == NULL) {
		printf("fopen failure %s", p->file);
		exit(EXIT_FAILURE);
	}
	while (fgets(str, max_str, fp) != NULL) {
		if (0 != strncmp(str, "#", 1)) {
			i++;
		}
	}
	fclose(fp);
	free(str);
	p->dat_num = i;
	p->x = (double *) chk_calloc(p->dat_num, sizeof(double));
	p->y = (double *) chk_calloc(p->dat_num, sizeof(double));
	return;
}

void param_free(p)
param *p;
{
	free(p->file);
	free(p->x);
	free(p->y);
	free(p);
	return;
}

void param_print(p)
param *p;
{
	printf("# max_filename\t=\t%d\n", p->max_filename);
	printf("# max_str\t=\t%d\n", p->max_str);
	printf("# file\t=\t%s\n", p->file);
	printf("# dat_num\t=\t%d\n", p->dat_num);
	return;
}

void dimension2d(param * p);

double radius2d(const double sum_x, const double sum_y,
		const double sum_xx, const double sum_yy, const int N_);

double radius2d(sum_x, sum_y, sum_xx, sum_yy, N_)
const double sum_x;
const double sum_y;
const double sum_xx;
const double sum_yy;
const int N_;
{
	double N = (double) N_;
	double rad = 0.0;
	rad =
	    (sum_xx + sum_yy) / N - (sum_x * sum_x +
				     sum_y * sum_y) / (N * N);
	return rad;
}

void dimension2d(p)
param *p;
{
	double rad = 0.0;
	double c0=0.0;
	double  c1=0.0;
	double  cov00=0.0;
	double  cov01=0.0;
	double  cov11=0.0;
	double  sumsq=0.0;
	/*
	double sum_xx = 0.0;
	double sum_yy = 0.0;
	double sum_x = 0.0;
	double sum_y = 0.0;
	*/
	double mean_x = 0.0;
	double mean_y = 0.0;
	double val_x = 0.0;
	double val_y = 0.0;
	double *x = p->x;
	double *y = p->y;
	double x_i = 0.0;
	double y_i = 0.0;
	size_t i = 0;
	int max_str = (int) p->max_str;
	char *str = (char *) chk_calloc(p->max_str, sizeof(char));
	double *logR = (double *) chk_calloc(p->dat_num, sizeof(double));
	double *logN = (double *) chk_calloc(p->dat_num, sizeof(double));
	FILE *fp;
	fp = fopen(p->file, "r");
	if (fp == NULL) {
		printf("fopen failure %s", p->file);
		exit(EXIT_FAILURE);
	}
	while (fgets(str, max_str, fp) != NULL) {
		if (0 != strncmp(str, "#", 1)) {
			sscanf(str, "%le %le", &x_i, &y_i);
			x[i] = x_i;
			y[i] = y_i;
			mean_x = gsl_stats_mean(x, 1, i + 1);
			mean_y = gsl_stats_mean(y, 1, i + 1);
			val_x = gsl_stats_variance_m(x, 1, i + 1, mean_x);
			val_y = gsl_stats_variance_m(y, 1, i + 1, mean_y);
			rad = (val_x + val_y)*(double)i/((double)i+1);
			if (i==0){rad=0;}
			logR[i] = log(rad);
			logN[i] = log((double)i+1);
			if(i>0){
				logR[0]=logR[1];
				logN[0]=logN[1];
			gsl_fit_linear (logR, 1, logN, 1, i+1, &c0, &c1, &cov00, &cov01, &cov11, &sumsq);
			}
			/*
			sum_xx += x_i * x_i;
			sum_yy += y_i * y_i;
			sum_x += x_i;
			sum_y += y_i;
			rad =
			    radius2d(sum_x, sum_y, sum_xx, sum_yy,
				     (int) i + 1);
			   printf("% .18e\t",rad);
			   printf("% d\n",i+1);
			   printf("%e %e ",x_i,y_i);
			   printf("%e %e ",sum_x/(i+1),sum_y/(i+1));
			printf("%e %e ", mean_x, mean_y);
			printf("%e %e ", val_x, val_y);
			 */
			printf("% e ", rad);
			printf("% d ", i+1);
			printf("% e % e ", logR[i], logN[i]);
			printf("% e % e ", c0, c1);
			printf("% d\n", i);
			/*
			printf("%e %e %e ", cov00, cov01, cov11);
			printf("%e\n", sumsq);
			*/
			i++;
		}
	}
	fclose(fp);
	free(str);
	free(logN);
	free(logR);
	/*
	   printf("%e %e %e %e %e %e %d\n",x,y,sum_x,sum_y,sum_xx,sum_yy,i);
	   printf("%e %e\n",sum_x/i,sum_y/i);
	   printf("%e %e\n",sum_xx/i,sum_yy/i);
	 */
	return;
}

int main(int, char **argv);

int main(argc, argv)
int argc;
char **argv;
{
	param *p = param_alloc();
	param_init(p);
	param_print(p);
	dimension2d(p);
	param_free(p);
	return 0;
	printf("%d", argc);
	printf("%s", argv[0]);
}
