﻿using System;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace NaGet.InteropServices
{
	/// <summary>
	/// COMをComInteropを経由せずにいじるための関数集
	/// </summary>
	public sealed class ComDirectAccess
	{
		[DllImport("ole32.dll")]
		public static extern int CoInitialize(IntPtr pvReserved);
		
		[DllImport("ole32.dll")]
		public static extern void CoUninitialize();
		
		[DllImport("ole32.dll", ExactSpelling=true, PreserveSig=false)]
		[return: MarshalAs(UnmanagedType.Interface)]
		static extern object CoCreateInstance(
			[In, MarshalAs(UnmanagedType.LPStruct)] Guid rclsid,
			[MarshalAs(UnmanagedType.IUnknown)] object pUnkOuter,
			CLSCTX dwClsContext,
			[In, MarshalAs(UnmanagedType.LPStruct)] Guid riid);
		
		[Flags()]
		public enum CLSCTX : uint
		{
		    CLSCTX_INPROC_SERVER    = 0x1,
		    CLSCTX_INPROC_HANDLER   = 0x2,
		    CLSCTX_LOCAL_SERVER     = 0x4,
		    CLSCTX_INPROC_SERVER16  = 0x8,
		    CLSCTX_REMOTE_SERVER    = 0x10,
		    CLSCTX_INPROC_HANDLER16 = 0x20,
		    CLSCTX_RESERVED1        = 0x40,
		    CLSCTX_RESERVED2        = 0x80,
		    CLSCTX_RESERVED3        = 0x100,
		    CLSCTX_RESERVED4        = 0x200,
		    CLSCTX_NO_CODE_DOWNLOAD = 0x400,
		    CLSCTX_RESERVED5        = 0x800,
		    CLSCTX_NO_CUSTOM_MARSHAL    = 0x1000,
		    CLSCTX_ENABLE_CODE_DOWNLOAD = 0x2000,
		    CLSCTX_NO_FAILURE_LOG       = 0x4000,
		    CLSCTX_DISABLE_AAA      = 0x8000,
		    CLSCTX_ENABLE_AAA       = 0x10000,
		    CLSCTX_FROM_DEFAULT_CONTEXT = 0x20000,
		    CLSCTX_INPROC           = CLSCTX_INPROC_SERVER|CLSCTX_INPROC_HANDLER,
		    CLSCTX_SERVER           = CLSCTX_INPROC_SERVER|CLSCTX_LOCAL_SERVER|CLSCTX_REMOTE_SERVER,
		    CLSCTX_ALL              = CLSCTX_SERVER|CLSCTX_INPROC_HANDLER,
		}
		
		/// <summary>
		/// 初期化禁止
		/// </summary>
		private ComDirectAccess()
		{
		}
		
		/// <summary>
		/// COMオブジェクトを生成する。CoCreateInstanceのラッパメソッド
		/// </summary>
		/// <param name="rclsid">オブジェクトのCLSID</param>
		/// <param name="pUnkOuter">アグリゲートオブジェクト</param>
		/// <param name="dwClsContext">コンテキスト</param>
		/// <param name="riid">オブジェクトのIID</param>
		/// <returns>生成されたCOMオブジェクト</returns>
		public static object CreateInstance(Guid rclsid, object pUnkOuter, CLSCTX dwClsContext, Guid riid)
		{
			return CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid);
		}
		
		/// <summary>
		/// COMオブジェクトを生成する。COMオブジェクトの型はテンプレートTから自動取得・キャストされる。
		/// </summary>
		/// <param name="clsid">オブジェクトのCLSID</param>
		/// <param name="dwClsContext">コンテキスト</param>
		/// <returns>生成されたCOMオブジェクト</returns>
		public static T CreateInstance<T>(Guid clsid, CLSCTX dwClsContext)
		{
			Guid riid = new Guid(((GuidAttribute) Attribute.GetCustomAttribute(typeof(T), typeof(GuidAttribute))).Value);
			return (T) CreateInstance(clsid, null, dwClsContext, riid);
		}
	}
}
