﻿using System;
using System.Diagnostics;
using NaGet.Tasks;

namespace NaGet.SubCommands.SubTask
{
	/// <summary>
	/// 関数をサブタスク化
	/// </summary>
	public class FunctionalSubTask<T> : NaGetSubTask
	{
		private Action<T> func = null;
		
		private T arg = default(T);
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="func">関数</param>
		/// <param name="arg">関数への引数</param>
		public FunctionalSubTask(Action<T> func, T arg)
		{
			this.func = func;
			this.arg = arg;
		}
		
		public override void Run()
		{
			NotifyStarted();
			try {
				func(arg);
			} finally {
				NotifyCompleted();
			}
		}
		
		/// <summary>
		/// 進捗は提供しない。
		/// </summary>
		public override bool UseProgress {
			get { return false; }
		}
	}
}
