﻿using System;
using NaGet.Tasks;

namespace NaGet.SubCommands.SubTask
{
	/// <summary>
	/// サブタスクの基底クラス。
	/// </summary>
	public abstract class NaGetSubTask : Task
	{
		private bool isRunning = false;
		
		private bool isDone = false;
		
		private bool isCancelled = false;
		
		public NaGetSubTask()
		{
		}
		
		/// <summary>
		/// 進捗情報を提供するか?
		/// </summary>
		public virtual bool UseProgress {
			get {
				return true;
			}
		}
		
		public override bool Running {
			get {
				return isRunning;
			}
		}
		
		public override bool Done {
			get {
				return isDone;
			}
		}
		
		public virtual bool Cancelled {
			get {
				return isCancelled;
			}
		}
		
		#region フラグ処理の便利メソッド
		
		/// <summary>
		/// 開始時に関するフラグの処理を行う
		/// </summary>
		protected virtual void NotifyStarted()
		{
			isRunning = true;
			isDone = false;
		}
		
		/// <summary>
		/// キャンセル中断時に関するフラグの処理を行う
		/// </summary>
		protected virtual void NotifyCancelled()
		{
			isRunning = false;
			isCancelled = true;
			isDone = true;
		}
		
		/// <summary>
		/// 成功終了時に関するフラグの処理を行う
		/// </summary>
		protected virtual void NotifyCompleted()
		{
			isRunning = false;
			isDone = true;
		}
		
		#endregion
	}
}
