/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "LoginDialog.h"

BEGIN_EVENT_TABLE(LoginDialog,wxDialog)
	EVT_BUTTON(LoginDialog::ID_BUTTON_CONNECT_TO_NETWORK,LoginDialog::onClickButton)
	EVT_BUTTON(LoginDialog::ID_BUTTON_CREATE_NETWORK,LoginDialog::onClickButton)
END_EVENT_TABLE()

LoginDialog::LoginDialog(wxFrame *parent) : wxDialog(parent,wxID_ANY,wxT("ログイン"),wxDefaultPosition,wxSize(400,320),wxCAPTION|wxCLOSE_BOX|wxSTAY_ON_TOP) {
	sizer=new wxBoxSizer(wxVERTICAL);

	sizer->Add(new wxStaticBitmap(this,wxID_ANY,wxBitmap(wxT("logo.png"),wxBITMAP_TYPE_PNG)),0,wxALIGN_CENTER);

	nameSizer=new wxBoxSizer(wxHORIZONTAL);

	nameSizer->Add(new wxStaticText(this,wxID_ANY,wxT("名前")),0,wxALL|wxCENTER,5);

	nameEdit=new wxTextCtrl(this,wxID_ANY);
	nameEdit->SetMaxLength(30);
	nameEdit->SetFocus();
	nameSizer->Add(nameEdit,1,wxALL,5);

	sizer->Add(nameSizer,0,wxEXPAND|wxALL,5);

	initNodeSizer=new wxStaticBoxSizer(wxHORIZONTAL,this,wxT("初期ノード"));

	initNodeSizer->Add(new wxStaticText(this,wxID_ANY,wxT("ホスト")),0,wxALL|wxCENTER,5);

	initNodeHostEdit=new wxTextCtrl(this,wxID_ANY);
	initNodeSizer->Add(initNodeHostEdit,1,wxALL,5);

	initNodeSizer->Add(new wxStaticText(this,wxID_ANY,wxT("ポート")),0,wxALL|wxCENTER,5);

	initNodePortEdit=new wxTextCtrl(this,wxID_ANY,wxT("65000"),wxDefaultPosition,wxSize(40,0),0,wxTextValidator(wxFILTER_NUMERIC));
	initNodeSizer->Add(initNodePortEdit,0,wxALL|wxEXPAND,5);

	sizer->Add(initNodeSizer,0,wxEXPAND|wxALL,5);

	listenSizer=new wxStaticBoxSizer(wxHORIZONTAL,this,wxT("接続受付"));

	listenSizer->Add(new wxStaticText(this,wxID_ANY,wxT("ポート")),0,wxALL|wxCENTER,5);

	listenPortEdit=new wxTextCtrl(this,wxID_ANY,wxT("65000"),wxDefaultPosition,wxDefaultSize,0,wxTextValidator(wxFILTER_NUMERIC));
	listenSizer->Add(listenPortEdit,0,wxEXPAND|wxALL,5);

	sizer->Add(listenSizer,0,wxEXPAND|wxALL,5);

	buttonSizer=new wxBoxSizer(wxHORIZONTAL);

	sizer->Add(0,0,1,wxEXPAND);

	connectToNetworkButton=new wxButton(this,ID_BUTTON_CONNECT_TO_NETWORK,wxT("ネットワークに接続(&J)"));
	buttonSizer->Add(connectToNetworkButton,0,wxALL,5);

	createNetworkButton=new wxButton(this,ID_BUTTON_CREATE_NETWORK,wxT("ネットワークを作成(&C)"));
	buttonSizer->Add(createNetworkButton,0,wxALL,5);

	exitButton=new wxButton(this,wxID_CANCEL,wxT("終了(&X)"));
	buttonSizer->Add(exitButton,0,wxALL,5);

	sizer->Add(buttonSizer,0,wxALL|wxALIGN_RIGHT,5);

	SetSizer(sizer);
}

void LoginDialog::onClickButton(wxCommandEvent &event) {
	EndModal(event.GetId());
}
