/*
	AramakiOnline
	Copyright (C) 2008 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINFRAME_H_
#define MAINFRAME_H_

#include "gui.h"

class MainFrame : public MainFrameBase {
	//singleton
	MainFrame();

	//送信
	void onClickSendButton(wxCommandEvent &);
	//ログイン
	void onSelectLoginMenu(wxCommandEvent &);
	//ログアウト
	void onSelectLogoutMenu(wxCommandEvent &);
	//キャラクター変更
	void onSelectChangeCharacterMenu(wxCommandEvent &);
	//無視
	void onSelectIgnoreMenu(wxCommandEvent &);
	//効果音
	void onSelectEnableSeMenu(wxCommandEvent &);
	//最前面表示
	void onSelectTopmostMenu(wxCommandEvent &);
	//マニュアル
	void onSelectManualMenu(wxCommandEvent &);
	//終了メニューが選択された
	void onSelectExitMenu(wxCommandEvent &);
	//発言内容入力欄でキーが押された
	void onKeyDownMessageEdit(wxKeyEvent &event);
	//送信
	void send();

	MainFrame(const MainFrame &);
	void operator=(const MainFrame &);
public:
	//singleton
	static MainFrame &getInstance();
	//ログを追加
	void appendLog(const wxString &name,const wxString &message);
	//発言入力欄にフォーカスをセット
	inline void setFocusToMessageEdit() {
		messageEdit->SetFocus();
	}
};

#endif /*MAINFRAME_H_*/
