/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.controls {
	import mx.core.UIComponent;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.render.AstroRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	public class Papervision3D extends UIComponent {
		/**
		 * シーン
		 */
		public var scene:Scene3D=new Scene3D;
		/**
		 * カメラ
		 */
		public var camera:Camera3D=new Camera3D;
		/**
		 * @private
		 */
		private var _viewport:Viewport3D;
		/**
		 * レンダラー
		 */
		public var renderer:AstroRenderEngine=new AstroRenderEngine;
		
		/**
		 * @inheritDoc
		 */
		override protected function createChildren():void {
			super.createChildren();
			
			createViewport(width,height);
		}
		
		/**
		 * ビューポートを再作成
		 */
		override protected function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void {
			super.updateDisplayList(unscaledWidth,unscaledHeight);
			
			removeChild(_viewport);
			createViewport(unscaledWidth,unscaledHeight);
		}
		
		/**
		 * ビューポートを作成
		 * 
		 * @param w ビューポートの幅
		 * @param h ビューポートの高さ
		 */
		private function createViewport(w:int,h:int):void {
			_viewport=new Viewport3D(w,h,false,true);
			addChild(_viewport);
		}
		
		/**
		 * ビューポート
		 */
		public function get viewport():Viewport3D {
			return _viewport;
		}
		
		/**
		 * シーンをレンダリング
		 */
		public function renderScene():void {
			renderer.renderScene(scene,camera,_viewport);
		}
	}
}