/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.events {
	import flash.events.Event;

	public class MessageEvent extends Event {
		/**
		 * 発言イベント
		 * 
		 * @eventType message
		 */
		static public const MESSAGE:String="message";
		/**
		 * ブロードキャストイベント
		 * 
		 * @eventType broadcast
		 */
		static public const BROADCAST:String="broadcast";
		
		/**
		 * @private
		 */
		private var _message:String;
		
		/**
		 * @param message メッセージ
		 */
		public function MessageEvent(type:String,bubbles:Boolean=false,cancelable:Boolean=false,message:String=null) {
			_message=message;
			
			super(type,bubbles,cancelable);
		}
		
		/**
		 * メッセージ
		 */
		public function get message():String {
			return _message;
		}
		
		/**
		 * @inheritDoc
		 */
		public override function clone():Event {
			return new MessageEvent(type,bubbles,cancelable,_message);
		}
		
		/**
		 * @inheritDoc
		 */
		public override function toString():String {
			return formatToString("MessageEvent","type","bubbles","cancelable","eventPhase","_message"); 
		}
	}
}