/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.net {
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.NetStatusEvent;
	import flash.events.SyncEvent;
	import flash.net.NetConnection;
	import flash.net.SharedObject;
	
	import jp.sourceforge.aramaki.events.PeerIdEvent;
	
	/**
	 * 接続完了イベント
	 * 
	 * @eventType flash.events.Event.CONNECT
	 */
	[Event(name="connect",type="flash.events.Event")]
	
	/**
	 * 接続失敗イベント
	 * 
	 * @eventType flash.events.ErrorEvent.ERROR
	 */
	[Event(name="error",type="flash.events.ErrorEvent")]
	
	/**
	 * 切断イベント
	 * 
	 * @eventType flash.events.Event.CLOSE
	 */
	[Event(name="close",type="flash.events.Event")]
	
	/**
	 * ピア接続要求イベント
	 * 
	 * @eventType jp.sourceforge.aramaki.events.PeerIdEvent.PEER_CONNECT
	 */
	[Event(name="peerConnect",type="jp.sourceforge.aramaki.events.PeerIdEvent")]
	
	/**
	 * ピア切断イベント
	 * 
	 * @eventType jp.sourceforge.aramaki.events.PeerIdEvent.PEER_CLOSE
	 */
	[Event(name="peerClose",type="jp.sourceforge.aramaki.events.PeerIdEvent")]
	
	/**
	 * ピアID管理クラス
	 */
	public class PeerManager extends EventDispatcher {
		/**
		 * ピア管理サーバーのアドレス
		 */
		//private static const SERVER_ADDRESS:String="rtmp:///PeerManager";
		private static const SERVER_ADDRESS:String="rtmp://aramakionline.mine.nu/PeerManager";
		/**
		 * ピア管理サーバーへ接続するためのNetConnection
		 */
		private var netConnection:NetConnection;
		/**
		 * ピアID管理用SharedObject
		 */
		private var sharedObject:SharedObject;
		/**
		 * ID
		 */
		private var _id:String;
		
		/**
		 * ピア管理サーバーへ接続
		 * 
		 * @param id ID
		 */
		public function connect(id:String):void {
			_id=id;
			
			netConnection=new NetConnection;
			netConnection.addEventListener(NetStatusEvent.NET_STATUS,netConnectionNetStatusHandler);
			netConnection.connect(SERVER_ADDRESS,id);
		}
		
		/**
		 * NetStatusハンドラ
		 */
		private function netConnectionNetStatusHandler(event:NetStatusEvent):void {
			switch(event.info.code) {
				case "NetConnection.Connect.Success": {
					//接続成功
					dispatchEvent(new Event(Event.CONNECT));
					
					sharedObject=SharedObject.getRemote("peers",netConnection.uri,false);
					sharedObject.addEventListener(SyncEvent.SYNC,sharedObjectFirstSyncHandler);
					sharedObject.connect(netConnection);
					
					break;
				}
				case "NetConnection.Connect.Failed": {
					//接続失敗
					dispose();
					
					dispatchEvent(new ErrorEvent(ErrorEvent.ERROR,false,false,"ピア管理サーバーへの接続に失敗しました"));
					
					break;
				}
				case "NetConnetion.Connect.Closed": {
					//切断
					close();
					
					break;
				}
			}
		}
		
		/**
		 * 最初のSyncEventハンドラ
		 */
		private function sharedObjectFirstSyncHandler(event:SyncEvent):void {
			sharedObject.removeEventListener(SyncEvent.SYNC,sharedObjectFirstSyncHandler);
			sharedObject.addEventListener(SyncEvent.SYNC,sharedObjectSyncHandler);
			
			for (var peerId:String in sharedObject.data) {
				if (peerId!=_id) {
					//接続要求をだす
					dispatchEvent(new PeerIdEvent(PeerIdEvent.PEER_CONNECT,false,false,peerId));
				}
			}
		}
		
		/**
		 * SyncEventハンドラ
		 */
		private function sharedObjectSyncHandler(event:SyncEvent):void {
			for each(var info:Object in event.changeList) {
				if (info.code=="delete") {
					//ピアが切断した
					dispatchEvent(new PeerIdEvent(PeerIdEvent.PEER_CLOSE,false,false,info.name));
					
					break;
				}
			}
		}
		
		/**
		 * 後始末
		 */
		private function dispose():void {
			if (sharedObject) {
				sharedObject.removeEventListener(SyncEvent.SYNC,sharedObjectFirstSyncHandler);
				sharedObject.removeEventListener(SyncEvent.SYNC,sharedObjectSyncHandler);
				sharedObject.close();
				sharedObject=null;
			}
			
			if (netConnection) {
				netConnection.removeEventListener(NetStatusEvent.NET_STATUS,netConnectionNetStatusHandler);
				netConnection.close();
				netConnection=null;
			}
		}
		
		/**
		 * ピア管理サーバーから切断する
		 */
		public function close():void {
			dispose();
			
			dispatchEvent(new Event(Event.CLOSE));
		}
	}
}