﻿/*
	AramakiOnline
	Copyright (C) 2008-2009 superbacker

	This program is free software; you can redistribute it and/or modify it under the terms
	of the GNU General Public License as published by the Free Software Foundation;
	either version 3 of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
	FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License along with this
	program. If not, see <http://www.gnu.org/licenses/>.
*/

package jp.sourceforge.aramaki.utils {
	import flash.display.DisplayObject;
	import flash.events.KeyboardEvent;
	
	public class KeyState {
		[ArrayElementType("Boolean")]
		private var state:Array = new Array;
		
		public function KeyState(captureObject:DisplayObject) {
			captureObject.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
			captureObject.addEventListener(KeyboardEvent.KEY_UP,keyUpHandler);
		}
		
		private function keyDownHandler(event:KeyboardEvent):void {
			state[event.keyCode] = true;
		}
		
		private function keyUpHandler(event:KeyboardEvent):void {
			state[event.keyCode] = false;
		}
		
		//キー状態を取得
		public function isDown(keyCode:uint):Boolean {
			return state[keyCode];
		}
	}
}