package jp.sourceforge.aramaki.peerManager;

import java.util.Iterator;
import java.util.Set;

import org.red5.server.adapter.ApplicationAdapter;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.service.IServiceCapableConnection;

public class Application extends ApplicationAdapter {
	//接続しているクライアント全員のメソッドを呼び出す
	private void invokeAll(String method,Object[] args) {
		Iterator<IConnection> iterator=scope.getConnections();
		
		while(iterator.hasNext()) {
			IConnection conn=iterator.next();
			
			((IServiceCapableConnection)conn).invoke(method,args);
		}
	}
	
	//ピアが接続してきた
	@Override
	public boolean appConnect(IConnection connection,Object[] params) {
		String peerId=(String)params[0];
		
		if (peerId==null||peerId.equals("")) {
			//PeerIdが指定されていなければ接続拒否
			return false;
		}
		
		if (!(connection instanceof IServiceCapableConnection)) return false;
		
		connection.getClient().setAttribute("id",peerId);
		
		//クライアントの接続を通知
		invokeAll("peerConnect",new Object[]{peerId});
		
		//接続しているクライアントのIDのリストを送る
		Set<IClient> clients=scope.getClients();
		Iterator<IClient> i=clients.iterator();
		
		while(i.hasNext()) {
			IClient c=i.next();
			
			((IServiceCapableConnection)connection).invoke("peerConnect",new Object[]{c.getAttribute("id")});
		}
		
		return super.appConnect(connection,params);
	}
	
	//ピアが切断した
	@Override
	public void appDisconnect(IConnection connection) {
		//クライアントの切断を通知
		invokeAll("peerClose",new Object[]{(String)connection.getClient().getAttribute("id")});
		
		super.appDisconnect(connection);
	}
}
