# -*- coding: Windows-31J -*-

require 'sqlite3'
require 'fileutils'
require 'uri'
require 'pathname'


class URLtable
	Waiting       =   0
	WaitRetry     =   1
	
	SaveSuccess   = 800
	NewLocation   = 801
	NotFound      = 802
	SkipScheme    = 804
	
	ConectTimeout = 900
	ConnectError  = 901
	Forbidden     = 902
	AuthRequest   = 903
	Error4xx      = 904
	Error5xx      = 905
	EOFreached    = 906
	CannotGetNetHTTP = 907	# Net::HTTP ł͎擾łȂy[WiTCg͂j
	BadURI        = 908     # ƂURI݂
	
	
	
	def initialize(param={:path => nil, :db => nil})
		@db      = nil
		@dbFile  = nil
		@dataDir = nil
		
		self.dataDir = if param[:path] then param[:path] else "./save"    end
		self.saveDB  = if param[:db]   then param[:db]   else "./url.db3" end
	end
	
	def dataDir=(path)
		@dataDir = File.expand_path(path)
		FileUtils.mkdir_p(@dataDir)
	end
	
	def saveDB=(db)
		db=db.to_s
		raise ArgumentError if db.size == 0
		if @dbFile != db then
			@db.close if @db
			@dbFile = db
			dbinit(@dbFile)
		end
	end
	
	
	class ROW
		def initialize(dt={})
			@url           = dt[:url].to_s
			@status        = dt[:status].to_s
			@statusCode    = dt[:code].to_s
			@bytes         = dt[:bytes].to_i
			@tryNow        = dt[:try].to_i
			@message       = dt[:message].to_s
			@referrer      = dt[:referrer].to_s
			@savePath      = dt[:path].to_s
			@linkCount     = dt[:link].to_i
			@linkCountCGI  = dt[:cgilink].to_i
			@timeStamp     = dt[:filetime]
			@downloadTime  = dt[:downtime]
			@checksum      = dt[:checksum].to_s
			@priority      = if dt[:priority] then dt[:priority] else rand(0x3fffffff) end
			@execond       = dt[:execond].to_i
			@body          = dt[:body].to_s
			@contentType   = dt[:contentType].to_s
		end
		attr_accessor :url, :status, :statusCode, :bytes, :tryNow
		attr_accessor :message, :referrer, :savePath, :linkCount, :linkCountCGI
		attr_accessor :timeStamp, :downloadTime, :checksum, :priority, :execond
		attr_accessor :body, :contentType
		
		def uri
			return URI.parse(@url)
		end
		
		def to_a
			return [
				@url.to_s,
				@status.to_s,
				@statusCode.to_s,
				@bytes.to_i,
				@tryNow.to_i,
				@message.to_s,
				@referrer.to_s,
				@savePath.to_s,
				@linkCount.to_i,
				@linkCountCGI.to_i,
				@timeStamp.to_i,
				@downloadTime.to_i,
				@checksum.to_s,
				if @priority then @priority.to_i else rand(0x3fffffff) end,
				@execond.to_i,
				SQLite3::Blob.new( @body.to_s ),
				@contentType.to_s,
			]
		end
		
		def copy
			return Marshal.load(Marshal.dump self)
		end
	end


	def URLtable.create(fn)
		FileUtils.rm_f(fn)
		sql = <<'SQL'

-- URLe[u
create table URLinfo (
  URL           text NOT NULL UNIQUE,
  Status        text,
  StatusCode    text,
  Bytes         integer,
  TryNow        integer,
  Message       text,     -- Move̍sȂ
  Referrer      text,     -- t@
  SavePath      text,     -- ۑpXi΁j
  LinkCount     integer,  -- [g̃NJEg
  LinkCountCGI  integer,  -- cgi[g̃NJEg
  TimeStamp     integer,
  DownloadTime  integer,
  CheckSum      text,
  Priority      integer,  -- D揇
  ExeCondition  integer,  -- 0:҂ 1:gC҂ 800-:I 900:ُI
  Body          blob,     --
  ContentType   text,
  
  primary key(URL)
);

create index idx_URLinfo_StatusCode on URLinfo(StatusCode);
create index idx_URLinfo_Message on URLinfo(Message);
create index idx_URLinfo_CheckSum on URLinfo(CheckSum);
create index idx_URLinfo_Priority on URLinfo(Priority);
create index idx_URLinfo_ExeCondition on URLinfo(ExeCondition);
create index idx_URLinfo_ContentType on URLinfo(ContentType);

SQL
	
		vdb = SQLite3::Database.new(fn)
		vdb.busy_timeout(2000)
		vdb.transaction do
			begin
				vdb.execute_batch(sql)
			rescue SQLite3::SQLException
				raise
			end
		end
		
	end
	
	def dbinit(fn)
		FileUtils.mkdir_p(File.dirname(fn))
		URLtable.create(fn) unless File.exist?(fn)
		@db = SQLite3::Database.new(fn)
		@db.busy_timeout(10000)
	end
	private :dbinit
	
	def search_fn(dir)
		p "toobig adta"
		cur  = 1
		low  = 0
		high = 1
		fn = ''
		base = File.expand_path(dir)
		begin
			print "#{low} <#{cur}> #{high} : "
			fn = sprintf('%s/%012x.blob', base, cur)
			if File.exist?(dir+'/'+fn) then
				puts "found"
				low = cur
				if cur==high then
					high *= 2
					cur = high
				else
					cur = (high+low+1)/2
				end
			else
				puts "nofile"
				high = cur
				cur = (high+low)/2
				break if(high = low+1)
			end
		end while true
		puts "newfn = #{fn}"
		puts "from = #{@dbFile}"
		from = Pathname.new( File.dirname( File.expand_path(@dbFile) ) )
		tofn = Pathname.new( fn )
		tofn = tofn.relative_path_from( from )
		puts "return = #{tofn.to_s}"
		return [tofn.to_s, fn]
	end
	
	def save(text)
		(fn, full)=search_fn(@dataDir)
		FileUtils.mkdir_p(File.dirname(full))
		open(full,  'wb'){|f|
			f.write text
		}
		puts "write blob #{text.size}bytes to #{fn} * #{full}"
		return fn
	end

	def insert_query(row)
		write = row.to_a
		cnt = 0
		begin
			@db.execute(
				'insert into URLinfo (' +
					'URL, Status, StatusCode, Bytes, TryNow, ' +
					'Message, Referrer, SavePath, LinkCount, LinkCountCGI, ' +
					'TimeStamp, DownloadTime, CheckSum, Priority, ExeCondition, ' +
					'Body, ContentType' +
				') values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);', write
			)
		rescue SQLite3::TooBigException
			cnt += 1
			write[15]=''
			row.savePath = save(row.body)
			if cnt <2 then
				retry
			end
			raise
		end
	end

	SELECT_SQLBODY = 'select ' +
				'URL, Status, StatusCode, Bytes, TryNow, ' +
				'Message, Referrer, SavePath, LinkCount, LinkCountCGI, ' +
				'TimeStamp, DownloadTime, CheckSum, Priority, ExeCondition, ' +
				'Body, ContentType' +
			' from URLinfo'
	UPDATE_SQLBODY = 'update URLinfo set ' +
				'Status=?, StatusCode=?, Bytes=?, TryNow=?, ' +
				'Message=?, Referrer=?, SavePath=?, LinkCount=?, LinkCountCGI=?, ' +
				'TimeStamp=?, DownloadTime=?, CheckSum=?, Priority=?, ExeCondition=?, ' +
				'Body=?, ContentType=?'
		
	def update_query(row)
		a = row.to_a
		key = a.shift
		a << key
		@db.execute(
			UPDATE_SQLBODY + ' where URL=?;', a
		)
	end
	
	def select_query(cond='', data=[])
		sql = SELECT_SQLBODY
		if cond != '' then
			sql += ' where ' + cond
		end
		sql += ';'
		result = @db.query( sql, data )
		return result
	end
	
	def toRow_sub(x)
		row = nil
		if x then
			row = ROW.new({
				:url			=> x[0].to_s,
				:status		=> x[1].to_s,
				:code			=> x[2].to_s,
				:bytes		=> x[3].to_i,
				:try			=> x[4].to_i,
				:message	=> x[5].to_s,
				:referrer	=> x[6].to_s,
				:path			=> x[7].to_s,
				:link			=> x[8].to_i,
				:cgilink	=> x[9].to_i,
				:filetime	=> Time.at(x[10].to_i),
				:downtime	=> Time.at(x[11].to_i),
				:checksum	=> x[12].to_s,
				:priority	=> x[13].to_i,
				:execond	=> x[14].to_i,
				:body			=> x[15].to_s,
				:contentType => x[16].to_s,
			})
		end
		return row
	end
	
	def toRow(result)
		x=result.next; result.close
		return toRow_sub(x)
	end
	
	def read_sub(cond, data=[])
		result = select_query(cond, data)
		return toRow(result)
	end
	
	def read(url)
		return read_sub('URL=?', [url])
	end
	
	def notNil(row)
		if row then
			return row
		end
		return ROW.new
	end
	
	def [](key)
		return notNil( read(key) )
	end
	
	def update(data,force=true)
		begin
			insert_query(data)
		rescue SQLite3::ConstraintException
			if force then
				update_query(data)
			end
		end
	end
	
	def exists(key)
		if read(key) then
			return true
		end
		return false
	end
	
	def entry(cond='', data=[])
		if(cond.to_s.size==0)then
			return notNil(
				read_sub('ExeCondition<? order by priority desc limit 1;', [SaveSuccess])
			)
		else
			return notNil(
				read_sub(cond,data)
			)
		end
	end
	
	def rest
		res = @db.query('select COUNT(*) from URLinfo where ExeCondition < ?',[SaveSuccess])
		x=res.next
		res.close
		return x
	end
	
	def transaction
		@db.transaction do
			yield
		end
	end
	
	def each(cond='', data=[])
		result = select_query(cond, data)
		while x=result.next
			yield toRow_sub(x)
		end
		result.close
	end
	
	
	def my_query
		yield @db
	end
	
	
end
