
#ifndef _MX3_IOREGS_H_
#define _MX3_IOREGS_H_
#include <hermit.h>
#include "regmap.h"
#include "mx3_iomuxc.h"
#include "mx3_uart.h"
#include "mx3_ccm.h"
#include "mx3_pcmcia.h"

#define IO_BYTE(offset)  (*(volatile unsigned char *)(offset))
#define IO_SHORT(offset) (*(volatile unsigned short *)(offset))
#define IO_WORD(offset)  (*(volatile unsigned long *)(offset))

#define IO_IOMUXC(type, offset) (IO_##type(IOMUXC_BASE_ADDR + (offset)))
#define IO_UART1(type, offset)  (IO_##type(UART1_BASE_ADDR + (offset)))
#define IO_UART2(type, offset)  (IO_##type(UART2_BASE_ADDR + (offset)))
#define IO_CCM(type, offset)    (IO_##type(CCM_BASE_ADDR + (offset)))
#define IO_IPU(type, offset)    (IO_##type(IPU_BASE_ADDR + (offset)))
#define IO_GPIO1(type, offset)  (IO_##type(GPIO1_BASE_ADDR + (offset)))
#define IO_GPIO2(type, offset)  (IO_##type(GPIO2_BASE_ADDR + (offset)))
#define IO_GPIO3(type, offset)  (IO_##type(GPIO3_BASE_ADDR + (offset)))
#define IO_WEIM(type, offset)   (IO_##type(WEIM_BASE_ADDR + (offset)))
#define IO_PCMCIA(type, offset)	(IO_##type(PCMCIA_IF_BASE_ADDR + (offset)))
#define IO_IIM(type, offset)    (IO_##type(IIM_BASE_ADDR + (offset)))
#define IO_CSPI2(type, offset)  (IO_##type(CSPI2_BASE_ADDR + (offset)))

#endif	/* _MX3_IOREGS_H_ */
