/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_ARMADILLO_MEMREGIONS_H
#define _HERMIT_ARMADILLO_MEMREGIONS_H

#define FLASH_BANK1_START	0x00000000
#define FLASH_BANK1_SIZE	0x00400000

#define FLASH_BOOTLOADER_START  FLASH_BANK1_START
#define FLASH_BOOTLOADER_SIZE   0x10000
#define FLASH_KERNEL_START      (FLASH_BOOTLOADER_START + FLASH_BOOTLOADER_SIZE)
#define FLASH_KERNEL_SIZE       0x170000
#define FLASH_USERLAND_START    (FLASH_KERNEL_START + FLASH_KERNEL_SIZE)
#define FLASH_USERLAND_SIZE     0x270000
#define FLASH_CONFIG_START      (FLASH_USERLAND_START + FLASH_USERLAND_SIZE)
#define FLASH_CONFIG_SIZE       (FLASH_BANK1_START + FLASH_BANK1_SIZE - FLASH_CONFIG_START)

#define FLASH_OPTION_SIZE	0x2000
#define FLASH_OPTION_START	(FLASH_KERNEL_START - FLASH_OPTION_SIZE)

#define FLASH_BOOTLOADER_NAME   "bootloader"
#define FLASH_KERNEL_NAME       "kernel"
#define FLASH_USERLAND_NAME     "userland"
#define FLASH_CONFIG_NAME       "config"
#define FLASH_BANK1_NAME        "flash-1"

#define FLASH_BOOTLOADER_BLOCK  "8x8K/l"
#define FLASH_KERNEL_BLOCK      "23x64K"
#define FLASH_USERLAND_BLOCK    "39x64K"
#define FLASH_CONFIG_BLOCK      "1x64K"
#define FLASH_BANK1_BLOCK       "8x8K/l,63x64K"

#define SRAM_START		0x60000000
#define SRAM_SIZE		0x0000c000

#define BOOTROM_START		0x70000000
#define BOOTROM_SIZE		0x00000080

#define DRAM1_START		0xC0000000
#define DRAM1_SIZE		0x02000000

#ifdef BOOTMODE
#define FLASH_BANK1_MAPPED	0x70000000
#define FLASH_BOOTLOADER_MAPPED	FLASH_BANK1_MAPPED
#define FLASH_KERNEL_MAPPED      (FLASH_BOOTLOADER_MAPPED + FLASH_BOOTLOADER_SIZE)
#define FLASH_USERLAND_MAPPED    (FLASH_KERNEL_MAPPED + FLASH_KERNEL_SIZE)
#define FLASH_CONFIG_MAPPED      (FLASH_USERLAND_MAPPED + FLASH_USERLAND_SIZE)
#define SRAM_MAPPED		0x10000000
#define BOOTROM_MAPPED		0x00000000
#endif

/*
 * External I/O regions are remapped by boot mode as well.
 */
#ifdef BOOTMODE
#define EXT_CS8900_BASE		0x50000300
#else
#define EXT_CS8900_BASE		0x20000300
#endif

#define LINUX_PARAM_SIZE	(0x00000f00)
#define LINUX_PARAM_ADDRESS	(DRAM1_START + 0x00000100)

#define LINUX_SRC_SIZE		(FLASH_KERNEL_SIZE)
#define LINUX_SRC_ADDRESS	(0x00010000)
#define LINUX_LOAD_ADDRESS	(DRAM1_START + 0x00028000)

#define INITRD_SRC_SIZE		(0x00280000)
#define INITRD_SRC_ADDRESS	(0x00180000)
#define INITRD_LOAD_ADDRESS	(DRAM1_START + 0x01000000)


#define GUNZIP_MEM_SIZE 0x20000
#define GUNZIP_MEM_BASE (DRAM1_START + DRAM1_SIZE - GUNZIP_MEM_SIZE - 0x10000)

#endif /* _HERMIT_CDB89712_MEMREGIONS_H */

