#include <ep93xx/ioregs.h>
#include "board.h"

int arch_getchar(unsigned long timeout)
{
#if defined(CONSOLE)
#  if CONSOLE == 0
	if((board_info.id != BOARD_ID_A210 &&
	    board_info.id != BOARD_ID_A210C) || jumper_mode == 1){
		while (IO_UART1FR & UARTFR_RXFE);
		return IO_UART1DR & 0xff;
	}else{
		while (IO_UART2FR & UARTFR_RXFE);
		return IO_UART2DR & 0xff;
	}
#  elif CONSOLE == 1
  	while (IO_UART2FR & UARTFR_RXFE);
	return IO_UART2DR & 0xff;
#  else
#    error "unknown CONSOLE value"
#  endif
#endif
	return 0;
}

int arch_putchar(int c, unsigned long timeout)
{
#if defined(CONSOLE)
#  if CONSOLE == 0
	if((board_info.id != BOARD_ID_A210 &&
	    board_info.id != BOARD_ID_A210C) || jumper_mode == 1){
		while (IO_UART1FR & UARTFR_TXFF);
		IO_UART1DR = c;
	}else{
		while (IO_UART2FR & UARTFR_TXFF);
		IO_UART2DR = c;
	}
#  elif CONSOLE == 1
  	while (IO_UART2FR & UARTFR_TXFF);
	IO_UART2DR = c;
#  else
#    error "unknown CONSOLE value"
#  endif
#endif
	return 0;
}
