#ifndef _HERMIT_TARGET_IDE_CORE_H_
#define _HERMIT_TARGET_IDE_CORE_H_

/* data port */
#define IDE_DATA                 (info->data_port + 0x00)
#define IDE_ERROR                (info->data_port + 0x01)
#define IDE_FEAUTURES            (info->data_port + 0x01)
#define IDE_SECTOR_COUNT         (info->data_port + 0x02)
#define IDE_SECTOR_NUMBER        (info->data_port + 0x03)
#define IDE_SECTOR_CYLINDER_LOW  (info->data_port + 0x04)
#define IDE_SECTOR_CYLINDER_HIGH (info->data_port + 0x05)
#define IDE_DEVICE_HEAD          (info->data_port + 0x06)
#define IDE_STATUS               (info->data_port + 0x07)
#define IDE_COMMAND              (info->data_port + 0x07)

/* ctrl port */
#define IDE_ALTERNATE_STATUS     (info->ctrl_port + 0x00)
#define IDE_DEVICE_CONTROL       (info->ctrl_port + 0x00)

#define IDE_STATUS_BUSY          0x80
#define IDE_STATUS_DRDY          0x40
#define IDE_STATUS_DRQ           0x08
#define IDE_STATUS_ERR           0x01

#define IDE_COMMAND_READ_SECTORS 0x20
#define IDE_COMMAND_IDLE         0xe3
#define IDE_COMMAND_IDENTIFY     0xec

#define IDE_DEVICE_CONTROL_SRST  0x04
#define IDE_DEVICE_CONTROL_NIEN  0x02

#define IDE_LBA                  0x40


#define SECTOR_SIZE     0x200
#define INODE_SIZE      0x80


typedef struct {
	u8 boot_ind;
	u8 head;
	u8 sector;
	u8 cyl;
	u8 sys_ind;
	u8 end_head;
	u8 end_sector;
	u8 end_cylinder;
	u8 start4[4];
	u8 size4[4];
} partition_t;

typedef struct {
	/* fs */
	char name[16];
	u32 size;
	int compressed;
	u32 blocks[15];

	/* driver */
	u32 load_addr;

	/* ide */
	u32 partition_start;
	u32 partition_size;
} file_t;


typedef struct _ide_info {
	void *ext_priv; /* external private data */
	int (*ext_probe)(void *priv);
	void (*ext_remove)(void *priv);

	int devid;

	u32 data_port;
	u32 ctrl_port;

	int (*startup)(struct _ide_info *info);
	int (*read_sectors)(struct _ide_info *info, u32 lba,
			    u8 *buf, int count);
	int (*find_image)(struct _ide_info *info, int disk,
			  int pno, partition_t *partition, file_t *file);
	int (*file_copy)(struct _ide_info *info, file_t *file);
} ide_info_t;

extern int ide_probe(ide_info_t *info);
extern void ide_remove(ide_info_t *info);

#endif
