/*
 * Copyright (c) 2003 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/htypes.h>

#define PORTC_BASE_ADDR 0xffb00028
#define PORTC (*((volatile unsigned int *)PORTC_BASE_ADDR))

#define CMODE(port_num) (0x01000000 << (port_num))
#define CDIR(port_num)  (0x00010000 << (port_num)) /* 0: IN   1: OUT */
#define CSF(port_num)   (0x00000100 << (port_num))
#define CDATA(port_num) (0x00000001 << (port_num))

int is_mfgi_hi(void)
{
        word_t val;

        /* make sure MFGI (PORTC1) is properly configured */
        PORTC &= ~(CMODE(1) | CSF(1) | CDIR(1));

        /* now read the data */
        val = PORTC;
        if (val & CDATA(1))
                return ~(0); /* return non zero for TRUE */
        else
                return 0;    /* return zero for FALSE */
}
