/*
 * Copyright (c) 2003 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/buffer.h>
#include <target/crc.h>
#include <target/io.h>
#include <target/frob.h>
#include <target/flash.h>
#include <netarm/ioregs.h>
#include "memmap.h"
#include "linux.h"
#include "bootmode.h"
#if defined(ARMADILLOJ_STYPE)
#include "post.h"
#endif
#if defined(ENABLE_JIG)
#include "test.h"
#endif

char *target_profile = TARGET_PROFILE;

static const command_t *commands[] = {
	&help_command,
	&frob_command,
	&jump_command,
	&upload_command,
	&version_command,
#if defined(ARMADILLOJ_STYPE)
	&flash_erase_post_command,
#endif
        &memmap_command,
        &flash_erase_command,
        &flash_program_command,
	&download_command,
        &linux_command,
        &boot_command,
	0
};

ABBR(boot_command, 'b')
ABBR(help_command, '?')
ABBR(frob_command, 'f')
ABBR(version_command, 'V')
#if defined(ARMADILLOJ_STYPE)
ABBR(flash_erase_post_command, 'E');
#endif
#if defined(ENABLE_JIG)
ABBR(test_command, 0x02)
#endif

static const abbrev_t *abbrevs[] = {
	&boot_command_abbrev,
	&help_command_abbrev,
	&frob_command_abbrev,
	&version_command_abbrev,
#if defined(ARMADILLOJ_STYPE)
	&flash_erase_post_command_abbrev,
#endif
#if defined(ENABLE_JIG)
	&test_command_abbrev,
#endif
	0
};

unsigned long flash_id;

int hmain(void)
{
	command_list_t command_list = { commands, abbrevs, "hermit", 0 };

	//unprotect flash-device
	IO_MEM_CSBA &= ~CSBA_WP;

	flash_initialize(FLASH_TYPE_AMD, FLASH_START);
	flash_id = flash_get_id(FLASH_START);

        if (is_mfgi_hi())
                (*boot_command.func)(0, 0);

	/* startup stuff: print version string */
	(*version_command.func)(0, 0);
	init_crc32();

	do_command_loop(&command_list);
	for (;;);
}

