/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <stdarg.h>
#include <target/htypes.h>
#include <target/io.h>

static int dprint(int dec)
{

	int order = 1000000000;	/* for 32 bits */
	int count = 0, started;

	/*
	 * should switch to this algorithm instead:

        i = MAX_DIGITS;
        do {
                unsigned long long thispower = power_table[--i];
                char c = '0';
                while (thispower < num) {
                        num -= thispower;
                        c++;
                }
                output(c);
        } while (i);

	*/

	if (dec < 0) {
		++count; hputchar('-');
		dec = -dec;
	}

	for (started = 0; order >= 10; order /= 10) {
		if (dec >= order) {
			int digit = dec / order;
			++count; hputchar(digit + '0');
			dec -= digit * order;
			started = 1;
		} else if (started) {
			++count; hputchar('0');	
		}
	}
	++count; hputchar(dec + '0');
	return count;

}

static inline void xputchar(char c)
{
	hputchar((c<10) ? (c+'0') : (c-10+'a'));
}

static int xprint(word_t hex, int nbytes)
{
	int shift;
	for (shift = nbytes * 8 - 4; shift >= 0; shift -= 4)
		xputchar((hex >> shift) & 0xF);
	return nbytes * 2;
}

/* print a string, expanding CR to CRLF */
int hprint(const char *s)
{
	int count;
	for (count=0; *s; ++count) {
		if (*s == '\n')
			++count, hputchar('\r');
		hputchar(*s++);
	}
	return count;
}

/* mini-printf implementation */
int hprintf(const char *format, ...)
{
	va_list ap;
	int count = 0;
	enum state { NORMAL, LITERAL, FORMAT } state = NORMAL;

	va_start(ap, format);

	for (; *format; ++format) {
		switch (state) {

		case NORMAL:
			if (*format == '\n') {
				/* translate CR to CRLF */
				hputchar('\r');
				hputchar('\n');
				count += 2;
			} else if (*format == '\\') {
				state = LITERAL;
			} else if (*format == '%') {
				state = FORMAT;
			} else
				++count, hputchar(*format);
			break;

		case LITERAL:
			++count, hputchar(*format);
			state = NORMAL;
			break;

		case FORMAT:
			switch (*format) {
			case 'b':
				count += xprint(va_arg(ap, word_t), 1);	
				break;
			case 'c':
				++count, hputchar(va_arg(ap, int));
				break;
			case 'd':
				count += dprint(va_arg(ap, int));
				break;
			case 'h':
				count += xprint(va_arg(ap, word_t), 2);
				break;
			case 'p':
				count += hprint("0x");
				count += xprint(va_arg(ap, word_t),
					sizeof(word_t));
				break;
			case 's':
				count += hprint(va_arg(ap, char*));
				break;
			case 'x':
				count += xprint(va_arg(ap, word_t),
					sizeof(word_t));
				break;
			case '%':
				++count, hputchar('%');
				break;
			default:
				break;
			}
			state = NORMAL;
			break;

		}
	}

	va_end(ap);

	return count;
}

