#include <target/mmu.h>
#include "mode.h"

void boost_on(int mode)
{
#if defined(__PPC__) || defined(__powerpc__)
	__invalidate_dcache();
	__enable_dcache(0x80000000);
	__invalidate_icache();
	__enable_icache(0x80000000);
#elif __MICROBLAZE__
	unsigned int i;
	int cache_byte_size, cache_line_size;

	if (is_flash_spi()) {
		/* SZ130 */
		cache_byte_size = 8192;
		cache_line_size = 16;
	}
	else {
		/* SZ010, SZ030 */
		cache_byte_size = 8192;
		cache_line_size = 4;
	}
	for(i = 0; i < cache_byte_size; i += cache_line_size)
		__invalidate_icache(i);
	__enable_icache();
	if (is_flash_spi()) {
		/* SZ130 */
		cache_byte_size = 8192;
		cache_line_size = 16;
		for(i = 0; i < cache_byte_size; i += cache_line_size)
			__invalidate_dcache(i);
		__enable_dcache();
	}
#endif
}

void boost_off()
{
#if defined(__PPC__) || defined(__powerpc__)
	__disable_dcache();
	__disable_icache();
#elif __MICROBLAZE__
	__disable_icache();
	if (is_flash_spi()) {
		/* SZ130 */
		__disable_dcache();
	}
#endif
}
