
#ifndef _IOREGS_H_
#define _IOREGS_H_

#include "regmap.h"
#include "regs_uart.h"

#define IO_START	IO_BASE_PHYS

#define IO(offset)	(offset)

#define IO_BYTE(offset)	(*(volatile unsigned char *)(offset))
#define IO_WORD(offset)	(*(volatile unsigned long *)(offset))
#define IO_HALF(offset)	(*(volatile unsigned short *)(offset))

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_DEVICECFG		IO_WORD(SYSCON_DEVCFG)
#define IO_SYSSWLOCK		IO_WORD(SYSCON_SWLOCK)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_SDRAMGLOBALCFG	IO_WORD(SDRAMGLOBALCFG)
#define IO_SDRAMREFRESHTIME	IO_WORD(SDRAMREFRESHTIME)
#define IO_SDRAMBOOTSTATUS	IO_WORD(SDRAMBOOTSTATUS)
#define IO_SDRAMCFG0		IO_WORD(SDRAMCFG0)
#define IO_SDRAMCFG1		IO_WORD(SDRAMCFG1)
#define IO_SDRAMCFG2		IO_WORD(SDRAMCFG2)
#define IO_SDRAMCFG3		IO_WORD(SDRAMCFG3)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_SMCBCR0		IO_WORD(SMCBCR0)
#define IO_SMCBCR1		IO_WORD(SMCBCR1)
#define IO_SMCBCR2		IO_WORD(SMCBCR2)
#define IO_SMCBCR3		IO_WORD(SMCBCR3)
#define IO_SMCBCR6		IO_WORD(SMCBCR6)
#define IO_SMCBCR7		IO_WORD(SMCBCR7)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_GPIO_PADR		IO_WORD(GPIO_PADR)
#define IO_GPIO_PBDR		IO_WORD(GPIO_PBDR)
#define IO_GPIO_PCDR		IO_WORD(GPIO_PCDR)
#define IO_GPIO_PDDR		IO_WORD(GPIO_PDDR)
#define IO_GPIO_PEDR		IO_WORD(GPIO_PEDR)
#define IO_GPIO_PFDR		IO_WORD(GPIO_PFDR)
#define IO_GPIO_PGDR		IO_WORD(GPIO_PGDR)
#define IO_GPIO_PHDR		IO_WORD(GPIO_PHDR)
#define IO_GPIO_PADDR		IO_WORD(GPIO_PADDR)
#define IO_GPIO_PBDDR		IO_WORD(GPIO_PBDDR)
#define IO_GPIO_PCDDR		IO_WORD(GPIO_PCDDR)
#define IO_GPIO_PDDDR		IO_WORD(GPIO_PDDDR)
#define IO_GPIO_PEDDR		IO_WORD(GPIO_PEDDR)
#define IO_GPIO_PFDDR		IO_WORD(GPIO_PFDDR)
#define IO_GPIO_PGDDR		IO_WORD(GPIO_PGDDR)
#define IO_GPIO_PHDDR		IO_WORD(GPIO_PHDDR)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Uart
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_UART1DR		IO_WORD(UART1DR)
#define IO_UART1RSR		IO_WORD(UART1RSR)
#define IO_UART1ECR		IO_WORD(UART1ECR)
#define IO_UART1CR_H		IO_WORD(UART1CR_H)
#define IO_UART1CR_M		IO_WORD(UART1CR_M)
#define IO_UART1CR_L		IO_WORD(UART1CR_L)
#define IO_UART1CR		IO_WORD(UART1CR)
#define IO_UART1FR		IO_WORD(UART1FR)
#define IO_UART1MCR		IO_WORD(UART1MCR)
#define IO_UART1MSR		IO_WORD(UART1MSR)
#define IO_UART2DR		IO_WORD(UART2DR)
#define IO_UART2RSR		IO_WORD(UART2RSR)
#define IO_UART2ECR		IO_WORD(UART2ECR)
#define IO_UART2CR_H		IO_WORD(UART2CR_H)
#define IO_UART2CR_M		IO_WORD(UART2CR_M)
#define IO_UART2CR_L		IO_WORD(UART2CR_L)
#define IO_UART2CR		IO_WORD(UART2CR)
#define IO_UART2FR		IO_WORD(UART2FR)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//Ethernet
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define IO_MAC_RXCTL            IO_WORD(MAC_RXCTL)
#define IO_MAC_TXCTL            IO_WORD(MAC_TXCTL)
#define IO_MAC_TESTCTL          IO_WORD(MAC_TESTCTL)
#define IO_MAC_MIICMD           IO_WORD(MAC_MIICMD)
#define IO_MAC_MIIDATA          IO_WORD(MAC_MIIDATA)
#define IO_MAC_MIISTS           IO_WORD(MAC_MIISTS)

#define IO_MAC_SELFCTL          IO_WORD(MAC_SELFCTL)
#define IO_MAC_INTEN            IO_WORD(MAC_INTEN)
#define IO_MAC_INTSTSP          IO_WORD(MAC_INTSTSP)
#define IO_MAC_INTSTSC          IO_WORD(MAC_INTSTSC)

#define IO_MAC_DIAGAD           IO_WORD(MAC_DIAGAD)
#define IO_MAC_DIAGDATA         IO_WORD(MAC_DIAGDATA)

#define IO_MAC_GT               IO_WORD(MAC_GT)
#define IO_MAC_FCT              IO_WORD(MAC_FCT)
#define IO_MAC_FCF              IO_WORD(MAC_FCF)
#define IO_MAC_AFP              IO_WORD(MAC_AFP)
#define IO_MAC_HASHTB           IO_WORD(MAC_HASHTB)
#define IO_MAC_INDAD0           IO_BYTE(MAC_INDAD+0)
#define IO_MAC_INDAD1           IO_BYTE(MAC_INDAD+1)
#define IO_MAC_INDAD2           IO_BYTE(MAC_INDAD+2)
#define IO_MAC_INDAD3           IO_BYTE(MAC_INDAD+3)
#define IO_MAC_INDAD4           IO_BYTE(MAC_INDAD+4)
#define IO_MAC_INDAD5           IO_BYTE(MAC_INDAD+5)
#define IO_MAC_INDAD_UPPER      IO_WORD(INDAD_UPPER)

#define IO_MAC_FER              IO_WORD(MAC_FER)
#define IO_MAC_FERMASK          IO_WORD(MAC_FERMASK)
#define IO_MAC_FPSR             IO_WORD(MAC_FPSR)
#define IO_MAC_FFER             IO_WORD(MAC_FFER)
#define IO_MAC_GLINTSTS         IO_WORD(MAC_GLINTSTS)
#define IO_MAC_GLINTMSK         IO_WORD(MAC_GLINTMSK)
#define IO_MAC_GLINTROS         IO_WORD(MAC_GLINTROS)
#define IO_MAC_GLINTFRC         IO_WORD(MAC_GLINTFRC)
#define IO_MAC_TXCOLLCNT        IO_WORD(MAC_TXCOLLCNT)
#define IO_MAC_RXMISSCNT        IO_WORD(MAC_RXMISSCNT)
#define IO_MAC_RXRUNTCNT        IO_WORD(MAC_RXRUNTCNT)

#define IO_MAC_BMCTL            IO_WORD(MAC_BMCTL)
#define IO_MAC_BMSTS            IO_WORD(MAC_BMSTS)
#define IO_MAC_RXBCA            IO_WORD(MAC_RXBCA)
#define IO_MAC_TXBCA            IO_WORD(MAC_TXBCA)

#define IO_MAC_RXDBA            IO_WORD(MAC_RXDBA)
#define IO_MAC_RXDBL            IO_HALF(MAC_RXDBL)
#define IO_MAC_RXDCL            IO_HALF(MAC_RXDCL)
#define IO_MAC_RXDCA            IO_WORD(MAC_RXDCA)
#define IO_MAC_RXDEQ            IO_WORD(MAC_RXDEQ)
#define IO_MAC_RXSBA            IO_WORD(MAC_RXSBA)
#define IO_MAC_RXSBL            IO_HALF(MAC_RXSBL)
#define IO_MAC_RXSCL            IO_HALF(MAC_RXSCL)
#define IO_MAC_RXSCA            IO_WORD(MAC_RXSCA)
#define IO_MAC_RXSEQ            IO_WORD(MAC_RXSEQ)

#define IO_MAC_TXDBA            IO_WORD(MAC_TXDBA)
#define IO_MAC_TXDBL            IO_HALF(MAC_TXDBL)
#define IO_MAC_TXDCL            IO_HALF(MAC_TXDCL)
#define IO_MAC_TXDCA            IO_WORD(MAC_TXDCA)
#define IO_MAC_TXDEQ            IO_WORD(MAC_TXDEQ)
#define IO_MAC_TXSBA            IO_WORD(MAC_TXSBA)
#define IO_MAC_TXSBL            IO_WORD(MAC_TXSBL)
#define IO_MAC_TXSCL            IO_WORD(MAC_TXSCL)
#define IO_MAC_TXSCA            IO_WORD(MAC_TXSCA)
#define IO_MAC_TXSEQ            IO_WORD(MAC_TXSEQ)

#define IO_MAC_RXBTH            IO_WORD(MAC_RXBTH)
#define IO_MAC_TXBTH            IO_WORD(MAC_TXBTH)
#define IO_MAC_RXSTH            IO_WORD(MAC_RXSTH)
#define IO_MAC_TXSTH            IO_WORD(MAC_TXSTH)
#define IO_MAC_RXDTH            IO_WORD(MAC_RXDTH)
#define IO_MAC_TXDTH            IO_WORD(MAC_TXDTH)

#define IO_MAC_MAXFL            IO_WORD(MAC_MAXFL)
#define IO_MAC_RXHLEN           IO_WORD(MAC_RXHLEN)

#define IO_MAC_CFG_REG0         IO_WORD(MAC_CFG_REG0)
#define IO_MAC_CFG_REG1         IO_WORD(MAC_CFG_REG1)
#define IO_MAC_CFG_REG2         IO_WORD(MAC_CFG_REG2)

#endif	/* _IOREGS_H_ */
