#ifndef _IOREGS_H_
#define _IOREGS_H_


#define IO_START                        (0xFF000000)
#define MEM_MODULE_OFFSET               (0x00C00000)
#define SERIAL_OFFSET                   (0x00D00000)

#define NETARM_MEM_CS0_BASE_ADDR        (0x10)

#define	NETARM_SER_CH1_CTRL_A		(0x00)
#define	NETARM_SER_CH1_STATUS_A		(0x08)
#define	NETARM_SER_CH1_BITRATE		(0x0C)
#define	NETARM_SER_CH1_FIFO		(0x10)

#define IO_BYTE(offset)	(*(volatile unsigned char *)(IO_START + (offset)))
#define IO_WORD(offset)	(*(volatile unsigned long *)(IO_START + (offset)))

#define IO_MEM_CSBA          IO_WORD(MEM_MODULE_OFFSET + NETARM_MEM_CS0_BASE_ADDR)

#define IO_SER1_CTRL         IO_WORD(SERIAL_OFFSET + NETARM_SER_CH1_CTRL_A)
#define IO_SER1_STATA        IO_WORD(SERIAL_OFFSET + NETARM_SER_CH1_STATUS_A)
#define IO_SER1_BITRATE      IO_WORD(SERIAL_OFFSET + NETARM_SER_CH1_BITRATE)
#define IO_SER1_FIFO_BYTE    IO_BYTE(SERIAL_OFFSET + NETARM_SER_CH1_FIFO)
#define IO_SER1_FIFO_WORD    IO_WORD(SERIAL_OFFSET + NETARM_SER_CH1_FIFO)

#define CSBA_WP (1<< 1)

#define SCCR_RTSRX (1<<22)
#define SCCR_DTR   (1<<17)
#define SCCR_RTS   (1<<16)

#define SCSR_RXFDB (3<<20)
#define SCSR_ROVER (1<<12)
#define RRDY       (1<<11)
#define SCSR_RBC   (1<< 9)
#define TRDY       (1<< 3)

#define IO_SER1_STATA_RXFDB  ((IO_SER1_STATA >> 20) & 0x3)

#endif	/* _IOREGS_H_ */
