
#ifndef _IOREGS_H_
#define _IOREGS_H_

#include "ns9750.h"

#define A3X0_EXT_PHYS_BASE	(0x60000000)
#define EXT_MISC_GCR		(0x000c)


#define IO_BYTE(offset)		(*(volatile unsigned char *)(offset))
#define IO_WORD(offset)		(*(volatile unsigned long *)(offset))

#define IO_SER(type, offset)	(IO_##type(NS9750_SER_PHYS_BASE + (offset)))
#define IO_SCM(type, offset)	(IO_##type(NS9750_SCM_PHYS_BASE + (offset)))
#define IO_I2C(type, offset)	(IO_##type(NS9750_I2C_PHYS_BASE + (offset)))
#define IO_ETH(type, offset)	(IO_##type(NS9750_ETH_PHYS_BASE + (offset)))
#define IO_EXT(type, offset)	(IO_##type(A3X0_EXT_PHYS_BASE + (offset)))

#define IO_SER_CHB_STATUS_A	IO_SER(WORD, NS_SER_CHB_STATUS_A)
#define IO_SER_CHB_FIFO_DATA	IO_SER(WORD, NS_SER_CHB_FIFO_DATA)
#define IO_SER_CHB_FIFO_DATA_B	IO_SER(BYTE, NS_SER_CHB_FIFO_DATA)
#define IO_SER_CHA_STATUS_A	IO_SER(WORD, NS_SER_CHA_STATUS_A)
#define IO_SER_CHA_FIFO_DATA	IO_SER(WORD, NS_SER_CHA_FIFO_DATA)
#define IO_SER_CHA_FIFO_DATA_B	IO_SER(BYTE, NS_SER_CHA_FIFO_DATA)

#define IO_SCM_MISC_SYS_CONFIG	IO_SCM(WORD, NS_SCM_MISC_SYS_CONFIG)

#define IO_I2C_CMD_TX_DATA	IO_I2C(WORD, NS_I2C_CMD_TX_DATA)
#define IO_I2C_STATUS_RX_DATA	IO_I2C(WORD, NS_I2C_STATUS_RX_DATA)
#define IO_I2C_MASTER_ADDR	IO_I2C(WORD, NS_I2C_MASTER_ADDR)
#define IO_I2C_SLAVE_ADDR	IO_I2C(WORD, NS_I2C_SLAVE_ADDR)
#define IO_I2C_CONFIG		IO_I2C(WORD, NS_I2C_CONFIG)

#define IO_ETH_EGCR1		IO_ETH(WORD, NS_ETH_EGCR1)
#define IO_ETH_EGCR2		IO_ETH(WORD, NS_ETH_EGCR2)
#define IO_ETH_EGSR		IO_ETH(WORD, NS_ETH_EGSR)
#define IO_ETH_ETSR		IO_ETH(WORD, NS_ETH_ETSR)
#define IO_ETH_ERSR		IO_ETH(WORD, NS_ETH_ERSR)
#define IO_ETH_MAC1		IO_ETH(WORD, NS_ETH_MAC1)
#define IO_ETH_MAC2		IO_ETH(WORD, NS_ETH_MAC2)
#define IO_ETH_IPGT		IO_ETH(WORD, NS_ETH_IPGT)
#define IO_ETH_IPGR		IO_ETH(WORD, NS_ETH_IPGR)
#define IO_ETH_CLRT		IO_ETH(WORD, NS_ETH_CLRT)
#define IO_ETH_MAXF		IO_ETH(WORD, NS_ETH_MAXF)
#define IO_ETH_SUPP		IO_ETH(WORD, NS_ETH_SUPP)
#define IO_ETH_MCFG		IO_ETH(WORD, NS_ETH_MCFG)
#define IO_ETH_MCMD		IO_ETH(WORD, NS_ETH_MCMD)
#define IO_ETH_MADR		IO_ETH(WORD, NS_ETH_MADR)
#define IO_ETH_MWTD		IO_ETH(WORD, NS_ETH_MWTD)
#define IO_ETH_MRDD		IO_ETH(WORD, NS_ETH_MRDD)
#define IO_ETH_MIND		IO_ETH(WORD, NS_ETH_MIND)
#define IO_ETH_SA1		IO_ETH(WORD, NS_ETH_SA1)
#define IO_ETH_SA2		IO_ETH(WORD, NS_ETH_SA2)
#define IO_ETH_SA3		IO_ETH(WORD, NS_ETH_SA3)
#define IO_ETH_SAFR		IO_ETH(WORD, NS_ETH_SAFR)
#define IO_ETH_HT1		IO_ETH(WORD, NS_ETH_HT1)
#define IO_ETH_HT2		IO_ETH(WORD, NS_ETH_HT2)
#define IO_ETH_STAT		IO_ETH(WORD, NS_ETH_STAT)
#define IO_ETH_RXAPTR		IO_ETH(WORD, NS_ETH_RXAPTR)
#define IO_ETH_RXBPTR		IO_ETH(WORD, NS_ETH_RXBPTR)
#define IO_ETH_RXCPTR		IO_ETH(WORD, NS_ETH_RXCPTR)
#define IO_ETH_RXDPTR		IO_ETH(WORD, NS_ETH_RXDPTR)
#define IO_ETH_EINTR		IO_ETH(WORD, NS_ETH_EINTR)
#define IO_ETH_EINTREN		IO_ETH(WORD, NS_ETH_EINTREN)
#define IO_ETH_TXPTR		IO_ETH(WORD, NS_ETH_TXPTR)
#define IO_ETH_TXRPTR		IO_ETH(WORD, NS_ETH_TXRPTR)
#define IO_ETH_TXERBD		IO_ETH(WORD, NS_ETH_TXERBD)
#define IO_ETH_RXAOFF		IO_ETH(WORD, NS_ETH_RXAOFF)
#define IO_ETH_RXBOFF		IO_ETH(WORD, NS_ETH_RXBOFF)
#define IO_ETH_RXCOFF		IO_ETH(WORD, NS_ETH_RXCOFF)
#define IO_ETH_RXDOFF		IO_ETH(WORD, NS_ETH_RXDOFF)
#define IO_ETH_TXOFF		IO_ETH(WORD, NS_ETH_TXOFF)
#define IO_ETH_RXFREE		IO_ETH(WORD, NS_ETH_RXFREE)
#define IO_ETH_TXBD		IO_ETH(WORD, NS_ETH_TXBD)

#define IO_EXT_MISC_GCR		IO_EXT(BYTE, EXT_MISC_GCR)

#endif	/* _IOREGS_H_ */

