#include <target/assert.h>
#include <target/medium.h>
#include <cs89712/ioregs.h>
#include "eth.h"

#ifdef ENABLE_MEDIUM_ETHERNET
/* buffer used to read commands from the Ethernet interface */
static unsigned char ethdata [128];
static int ethdata_count, ethdata_pos;
#endif

int arch_getchar(unsigned long timeout)
{
	if (current_medium == MEDIUM_SERIAL) {
#if defined(CONSOLE) && CONSOLE == 1
		while (IO_SYSFLG2 & URXFE2);
		return IO_UARTDR2 & 0xff;
#elif defined(CONSOLE) && CONSOLE == 0
		while (IO_SYSFLG1 & URXFE1);
		return IO_UARTDR1 & 0xff;
#endif
	}
#ifdef ENABLE_MEDIUM_ETHERNET
	if (current_medium == MEDIUM_ETHERNET) {
		/* ethernet commands */
		if (ethdata_pos == ethdata_count) {
			/* read a packet from the Ethernet */
			ethdata_count = ether_read(ethdata, sizeof ethdata);
			assert(ethdata_count > 0);
			assert(ethdata_count <= sizeof ethdata);
			ethdata_pos = 0;
		}
		return ethdata[ethdata_pos++];
	}
#endif
	return 0;
}

int arch_putchar(int c, unsigned long timeout)
{
#if defined(CONSOLE) && CONSOLE == 1
	while (IO_SYSFLG2 & UTXFF2);
	IO_UARTDR2 = (unsigned char) c;
#elif defined(CONSOLE) && CONSOLE == 0
	while (IO_SYSFLG1 & UTXFF1);
	IO_UARTDR1 = (unsigned char) c;
#endif
	return 0;
}
