/*
 * Copyright (c) 2004-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <ep93xx/ioregs.h>
#include <ep93xx/memcpy.h>
#include <target/herrno.h>
#include <target/io.h>
#include <target/scan.h>
#include <target/str.h>
#include <target/buffer.h>
#include <target/memcmp.h>
#include <target/atag.h>
#include <target/gunzip.h>
#include "linux.h"
#include "memmap.h"
#include <target/memzero.h>
#include <target/flash.h>
#include <target/setenv.h>
//#include "eth.h"
#include "board.h"
#include <target/mmu.h>

/* for setting the root device */
#define MINORBITS       8
#define MKDEV(ma,mi)    (((ma) << MINORBITS) | (mi))

#define RAMDISK_MAJOR   1	/* major for "RAM disk" */
#define RAMDISK0_MINOR	0	/* b 1 0 == /dev/ram0 */

#define ROM_FLASH_MAJOR	31	/* major for "ROM/flash memory card" */
#define FLASH0_MINOR	16	/* b 31 16 == /dev/flash0 */
#define FLASH1_MINOR	17	/* b 31 17 == /dev/flash1 */

static int major = RAMDISK_MAJOR;
static int minor = RAMDISK0_MINOR;

#define COMMAND_LINE_SIZE 1024

extern unsigned long bytes_out;

#define SECTOR_SIZE     0x200
#define INODE_SIZE      0x80

static int linux_cmdfunc(int argc, char *argv[])
{
	struct tag *tag = (struct tag *) LINUX_PARAM_ADDRESS;
	int sdram32bit = get_board_sdram32bit();

	/* zero param block */
	memzero (tag, LINUX_PARAM_SIZE);

	/* set up core tag */
	tag->hdr.tag = ATAG_CORE;
	tag->hdr.size = tag_size(tag_core);
	tag->u.core.flags = 0;
	tag->u.core.pagesize = 0x1000;
	tag->u.core.rootdev = MKDEV(major, minor);

	/* 32/8 MB of SDRAM at 0xc0000000 */
	tag = tag_next(tag);
	tag->hdr.tag = ATAG_MEM;
	tag->hdr.size = tag_size(tag_mem32);
	tag->u.mem.size = sdram32bit ? DRAM1_SIZE : DRAM1_SIZE16;
	tag->u.mem.start = sdram32bit ? DRAM1_START : DRAM1_START16;

	/* 32/8 MB of SDRAM at 0xc4000000/0xc1000000 */
	tag = tag_next(tag);
	tag->hdr.tag = ATAG_MEM;
	tag->hdr.size = tag_size(tag_mem32);
	tag->u.mem.size = sdram32bit ? DRAM2_SIZE : DRAM2_SIZE16;
	tag->u.mem.start = sdram32bit ? DRAM2_START : DRAM2_START16;

	if (!sdram32bit) {
	    /* 16 MB of SDRAM at 0xc4800000 */
	    tag = tag_next(tag);
	    tag->hdr.tag = ATAG_MEM;
	    tag->hdr.size = tag_size(tag_mem32);
	    tag->u.mem.size = DRAM3_SIZE16;
	    tag->u.mem.start = DRAM3_START16;
	}

	if (major == RAMDISK_MAJOR) {
	  /* an initial ramdisk image in flash at 0x00700000 */
	  tag = tag_next(tag);
	  tag->hdr.tag = ATAG_INITRD2;
	  tag->hdr.size = tag_size(tag_initrd);
	  tag->u.initrd.start = INITRD_LOAD_ADDRESS;
	  tag->u.initrd.size  = bytes_out;
	}

	/* the command line arguments */
	if (argc > 1) {
		tag = tag_next(tag);
		tag->hdr.tag = ATAG_CMDLINE;
		tag->hdr.size = (COMMAND_LINE_SIZE + 3 +
			 sizeof(struct tag_header)) >> 2;

		{
			const unsigned char *src;
			unsigned char *dst;
			dst = tag->u.cmdline.cmdline;
			memzero (dst, COMMAND_LINE_SIZE);
			while (--argc > 0) {
				src = *++argv;
				hprintf ("Doing %s\n", src);
				while (*src)
					*dst++ = *src++;
				*dst++ = ' ';
			}
			*--dst = '\0';
		}
	}

	tag = tag_next(tag);
	tag->hdr.tag = 0;
	tag->hdr.size = 0;

	/* branch to kernel image */
	__asm__ volatile (
	"	mov	r4, #0xC0000000\n"	/* start of DRAM */
	"	add	r4, r4, #0x00018000\n"	/* kernel offset */
	"	mov	r0, #0\n"		/* kernel sanity check */
	"	mov	r1, #0x100\n"           /* armadillo2x0 arch. number */
	"	orr     r1, r1, #0x82\n"	/* number = 0x182 (386) */
	"	mov	r2, #0\n"
	"	mov	r3, #0\n"
	"	mov	pc, r4"			/* go there! */
	);

	/* never get here */
	return 0;
}

char mtdparts210[] = { MTDPARTS210 };
char mtdparts2x0[] = { MTDPARTS2X0 };
char console[] = { "console=ttyAM0,115200" };

static int boot_cmdfunc(int argc, char *argv[])
{
	int i;
	int gunzip_kernel = 1;
	int o_argc = 0;

	if(argc > 1){
	  o_argc = argc;
	}else{
	  o_argc = get_option_count();
	}

	{
	char *o_argv[o_argc + 3];
	if(argc > 1){
	  for(i = 0; i < argc; i++){
	    o_argv[i] = argv[i];
	  }
	}else{
	  if(o_argc <= 1){
	    o_argv[o_argc++] = console;
	  }else{
	    get_options(o_argv);
	  }
	}

	major = RAMDISK_MAJOR;
	minor = RAMDISK0_MINOR;

	argc = o_argc;
	argv = o_argv;
	switch(get_board_id()) {
	case BOARD_ID_A210:
	case BOARD_ID_A210C:
	  argv[argc++] = mtdparts210;
	  console[13] = '1';
	  break;
	case BOARD_ID_A220:
	case BOARD_ID_A230:
	case BOARD_ID_A240:
	  argv[argc++] = mtdparts2x0;
	  break;
	default:
	  break;
	}

	for(i=0; i<o_argc; i++){
	  if(strncmp(o_argv[i], "console=", 8) == 0){
	    if(strncmp(&o_argv[i][8], "ttyAM0", 6) == 0){
	      jumper_mode = 1;
	    }else if(strncmp(&o_argv[i][8], "ttyAM1", 6) == 0){
	      jumper_mode = 0;
	    }else{
	      jumper_mode = 0;
	    }
	    break;
	  }
	}

	if(argc < 1)
		return -H_EUSAGE;
	
	LED_RED_ON();

	boost_on (BOOST_LINUX_MODE);
	if(gunzip_kernel){
	  gunzip_object(" kernel", LINUX_SRC_ADDRESS, LINUX_LOAD_ADDRESS);
	}
	if(major == RAMDISK_MAJOR){
	  gunzip_object("ramdisk", INITRD_SRC_ADDRESS, INITRD_LOAD_ADDRESS);
	}
	boost_off();

	linux_cmdfunc(argc, argv);
	}

	return 0;
}

const command_t linux_command =
	{ "linux", "<linux options>", "start Linux", &linux_cmdfunc };
const command_t boot_command =
	{ "boot", "", "boot default Linux kernel and ramdisk", &boot_cmdfunc };

