#include <ep93xx/ioregs.h>

#ifdef CONSOLE
#if CONSOLE == 1
#define IO_UARTDR       IO_UART2DR
#define IO_UARTFR       IO_UART2FR
#else
#define IO_UARTDR       IO_UART1DR
#define IO_UARTFR       IO_UART1FR
#endif
#endif


int arch_getchar(unsigned long timeout)
{
#ifdef CONSOLE
        while (IO_UARTFR & UARTFR_RXFE);
        return IO_UARTDR & 0xff;
#else
        return 0;
#endif
}

int arch_putchar(int c, unsigned long timeout)
{
#ifdef CONSOLE
        while (IO_UARTFR & UARTFR_TXFF);
        IO_UARTDR = c;
#endif
        return 0;
}
