/*
 * boot.S: assembly language bootstrap
 *
 * Copyright (c) 2003 Atmark Techno, Inc.
 *
 * Based on:
 *      Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include "memregions.h"

	.section .flash.boot
#ifdef ARMADILLOJ_CTYPE
	.long	0x414a4154
	.long	0x5f32424c
	.long	0x00000000
	.long	0x00000000
#endif

	.global _start_flash
_start_flash:
        /* make _DAMN_ sure to reset dma test bit */
	mov	r0, #0xff000000
	orr	r0, r0, #0x00b00000
	ldr	r1, [r0]
	mvn	r2, #0x00001000
	and	r1, r1, r2
	str	r1, [r0]

//	mov	r0, #0xff000000         /* load the address of PORT C */
//	orr	r0, r0, #0x00b00000     /* we used #6 as ether activity and #1 as hermit boot mode */

//	mov	r1, #0                  /* initialize all port as IN */
//	str	r1, [r0]

	mov	r0, #0xff000000         /* load the address of */
	orr	r0, r0, #0x00d00000     /* Serial Channel 1 Control Register A */

	mov	r1, #0x83000000         /* load serial settings CE, 1N8 */
	orr	r1, r1, #0x00430000     /* active RTS, DTR, RTS */
	str	r1, [r0]		/* store serial setttings */

	mov	r1, #0x08000000		/* load serial settings RBGT */
	str	r1, [r0, #0x4]		/* set Serial Channle 1 Control Register B */

	mov	r1, #0x80000000		/* load serial settings BT == 0 */
	str	r1, [r0, #0x14]         /* set Receive Buffer Gap Timer */

	mov	r0, #0xf000000c         /* load serial channel 1 bitrate register addr */
	orr	r0, r0, #0x0fd00000
	mov	r1, #0x80000000         /* load serial setting for 115200bps */
	str	r1, [r0]                /* set new serial settting */

	
	mov	sp, #DRAM_START		/* init stack pointer */
	add	sp, sp, #DRAM_SIZE

	bl	entry			/* see entry.c */
1:	b	1b

	.section .ram.boot
	.global _start_ram
_start_ram:
	bl	hmain
2:	b	2b

