/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <netarm/ioregs.h>
#include <target/io.h>
#include "memmap.h"

/*
 * The only vaguely tricky things about this memory map are:
 *
 * (1) It includes remapped memory addresses for the inverted mapping
 *     used by the CSC in boot mode, if we're compiling for that
 *     target.
 *
 * (2) Depicts flash block sizes as they are seen from outside the
 *     boot loader.  The flash parts are 16 bits wide (each spans 16
 *     bits of the data bus), so the blocks as seen by a flash
 *     programmer are twice data sheet size (of each 32-bit write, 16
 *     bits goes to each flash chip).
 */
static int memmap_cmdfunc(int argc, char *argv[])
{
#if defined(ARMADILLOJ_STYPE)
	hprintf("%p:%p FLA reserved bf:8K bl:%s\n"      \
		"%p:%p FLA hermit bf:64K bl:%s\n"       \
		"%p:%p FLA user bf:8K bl:%s\n"          \
 		"%p:%p RAM dram\n",
		RESERVED_START, RESERVED_START + RESERVED_SIZE - 1, reserved_blocking,
		HERMIT_START, HERMIT_START + HERMIT_SIZE - 1, hermit_blocking,
		USER_START, USER_START + USER_SIZE - 1, user_blocking,
		DRAM_START, DRAM_START + DRAM_SIZE - 1);
#endif

#if defined(ARMADILLOJ_CTYPE)
	hprintf("%p:%p FLA user bf:8K bl:%s\n"          \
		"%p:%p RAM dram\n",
                USER_START, USER_START + USER_SIZE - 1, user_blocking,
		DRAM_START, DRAM_START + DRAM_SIZE - 1);
#endif
	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

