/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <ep7211/ioregs.h>
#include <target/herrno.h>
#include <target/io.h>
#include "gunzip.h"
#include "linux.h"
#include "memmap.h"

/* leave 64K reserved for the boot loader (generous) */
#define LINUX_FLASH_ADDRESS	(64 * 1024)
#define LINUX_PARAM_ADDRESS	(DRAM1_START + 0x00020000)
#define LINUX_LOAD_ADDRESS	(DRAM1_START + 0x00028000)

/* for setting the root device */
#define MINORBITS       8
#define MKDEV(ma,mi)    (((ma) << MINORBITS) | (mi))

#define RAMDISK_MAJOR   1	/* major for "RAM disk" */
#define RAMDISK0_MINOR	0	/* b 1 0 == /dev/ram0 */

#define ROM_FLASH_MAJOR	31	/* major for "ROM/flash memory card" */
#define FLASH0_MINOR	16	/* b 31 16 == /dev/flash0 */
#define FLASH1_MINOR	17	/* b 31 17 == /dev/flash1 */

#define COMMAND_LINE_SIZE 1024

/* this comes straight from the kernel source */
struct param_struct {
	union {
		struct {
	 		unsigned long page_size;		/*  0 */
			unsigned long nr_pages;			/*  4 */
			unsigned long ramdisk_size;		/*  8 */
			unsigned long flags;			/* 12 */
#define FLAG_READONLY	1
#define FLAG_RDLOAD	4
#define FLAG_RDPROMPT	8
			unsigned long rootdev;			/* 16 */
			unsigned long video_num_cols;		/* 20 */
			unsigned long video_num_rows;		/* 24 */
			unsigned long video_x;			/* 28 */
			unsigned long video_y;			/* 32 */
			unsigned long memc_control_reg;		/* 36 */
			unsigned char sounddefault;		/* 40 */
			unsigned char adfsdrives;		/* 41 */
			unsigned char bytes_per_char_h;		/* 42 */
			unsigned char bytes_per_char_v;		/* 43 */
			unsigned long pages_in_bank[4];		/* 44 */
			unsigned long pages_in_vram;		/* 60 */
			unsigned long initrd_start;		/* 64 */
			unsigned long initrd_size;		/* 68 */
			unsigned long rd_start;			/* 72 */
			unsigned long system_rev;		/* 76 */
			unsigned long system_serial_low;	/* 80 */
			unsigned long system_serial_high;	/* 84 */
			unsigned long mem_fclk_21285;		/* 88 */
		} s;
		char unused[256];
	} u1;
	union {
		char paths[8][128];
		struct {
			unsigned long magic;
			char n[1024 - sizeof(unsigned long)];
		} s;
	} u2;
	char commandline[COMMAND_LINE_SIZE];
};

void start_linux(void)
{
	char *argv [2] = { "unzip", 0 };

#ifdef HAVE_LCD
	/* display splash screen */
	gunzip_splash();
#endif

	/* unzip and start kernel */
	(*unzip_command.func)((sizeof argv)/(sizeof *argv) - 1, argv);
	argv[0] = "linux";
	(*linux_command.func)((sizeof argv)/(sizeof *argv) - 1, argv);
}

static int linux_cmdfunc(int argc, char *argv[])
{
	struct param_struct *ps;
	const unsigned char *src;
	unsigned char *dst;
	int i;

	/* zero param block */
	ps = (struct param_struct*) LINUX_PARAM_ADDRESS;
	dst = (char*) ps;
	for (i = sizeof(struct param_struct); i; --i)
		*dst++ = 0;

	/* initialize param block */

	/* system page size */
	ps->u1.s.page_size = 0x1000;
	/* number of pages in all banks */
	ps->u1.s.nr_pages = 4096;
	/* param flags */
	ps->u1.s.flags = FLAG_READONLY;
	/* root filesystem device */
	ps->u1.s.rootdev = MKDEV(ROM_FLASH_MAJOR, FLASH1_MINOR);
	/* pages per bank */
	ps->u1.s.pages_in_bank[0] = 2048;
	ps->u1.s.pages_in_bank[1] = 2048;

	/* copy command line arguments to param area (bounds not checked) */
	dst = ps->commandline;
	while (--argc > 0) {
		src = *++argv;
		while (*src)
			*dst++ = *src++;
		*dst++ = ' ';
	}
	if (dst != (unsigned char*) ps->commandline)
		*--dst = '\0';

	/* branch to kernel image */
	__asm__ volatile (
	"	mov	r4, #0xC0000000\n"	/* start of DRAM */
	"	add	r4, r4, #0x00028000\n"	/* kernel offset */
	"	mov	r0, #0\n"		/* kernel sanity check */
	"	mov	r1, #50\n"		/* EDB7211 arch. number */
	"	mov	r2, #0\n"
	"	mov	r3, #0\n"
	"	mov	pc, r4"			/* go there! */
	);

	/* never get here */
	return 0;
}

static int unzip_cmdfunc(int argc, char *argv[])
{
	/* turn on LED flasher (25% duty cycle) */
	IO_LEDFLSH = 0x4c; 
	
	/* decompress kernel image to DRAM */
	gunzip_kernel();

	/* turn off LED flasher */
	IO_LEDFLSH = 0;

	return 0;
}

const command_t linux_command =
	{ "linux", "<linux options>", "start Linux", &linux_cmdfunc };
const command_t unzip_command =
	{ "unzip", 0, "unzip Linux kernel", &unzip_cmdfunc };

