#include <target/io.h>
#include <target/net/eth_util.h>

static inline unsigned short _word_swap(unsigned short v){
  unsigned short _v;

  _v =  ((v & 0x00ff) << 8);
  _v |= ((v & 0xff00) >> 8);
  return _v;
}

static inline unsigned long _dword_swap(unsigned long v){
  unsigned long _v;

  _v =  ((v & 0x000000ff) << 24);
  _v |= ((v & 0x0000ff00) << 8);
  _v |= ((v & 0x00ff0000) >> 8);
  _v |= ((v & 0xff000000) >> 24);
  return _v;
}

unsigned short htons(unsigned short hostshort){
  return _word_swap(hostshort);
}

unsigned long htonl(unsigned long hostlong){
  return _dword_swap(hostlong);
}

unsigned short ntohs(unsigned short netshort){
  return _word_swap(netshort);
}

unsigned long ntohl(unsigned long netlong){
  return _dword_swap(netlong);
}

int safe_memcmp(const void *__str1, const void *__str2, const int __len){
  unsigned char *str1 = (unsigned char *)__str1;
  unsigned char *str2 = (unsigned char *)__str2;
  int loop = __len;
  int res;
  for(res = 0; 0<loop; loop--, str1++, str2++){
    res = *str1 - *str2;
    if(res != 0) break;
  }
  return res;
}

void *safe_memcpy(void *__dst, const void *__src, const int __len){
  unsigned char *dst = (unsigned char *)__dst;
  unsigned char *src = (unsigned char *)__src;
  int loop = __len;
  for(; 0<loop; loop--, dst++, src++){
    *dst = *src;
  }
  return __dst;
}

void *safe_memset(void *__src, const int __c, const int __len){
  unsigned char *src = (unsigned char *)__src;
  int loop = __len;
  for(; 0<loop; loop--, src++){
    *src = (unsigned char)__c;
  }
  return __src;
}

int safe_strlen(const char *str){
  int i;
  for(i=0;; i++){
    if(str[i] == 0) return i;
  }
}

int safe_strcmp(const char *str1, const char *str2){
  int i;
  int len;
  if(str1 == 0 || str2 == 0) return -1;
  len = safe_strlen(str1);
  if(len != safe_strlen(str2)) return -1;

  for(i=0; i<len; i++){
    if(str1[i] != str2[i]) return -1;
  }
  return 0;
}

int safe_strncmp(const char *str1, const char *str2, unsigned int n){
  int i;
  if(str1 == 0 || str2 == 0) return -1;

  for(i=0; i<n; i++){
    if(str1[i] != str2[i]) return -1;
    if(str1[i] == 0) return 0;
  }
  return 0;
}

void print_ip(unsigned char *ip){
  hprintf("%d.%d.%d.%d\n", ip[0], ip[1], ip[2], ip[3]);
}

void print_mac(unsigned char *mac){
  hprintf("%b:%b:%b:%b:%b:%b\n",
	  mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
}

#if defined(DEBUG_ETH)
void hexdump(char *str, unsigned char *buf, unsigned int len){
  int i;
  hprintf("hexdump: %s\n",str);
  for(i=0; i<len; i++){
    hprintf("%b ", buf[i]);
    if(i%16 == 15) hprintf("\n");
  }
  if(i%16 != 0) hprintf("\n");
}
#endif

