/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 * Copyright (c) 2003-2005 Atmark Techno, Inc. All Rights Reserved.
 */

#include <target/io.h>
#include "memmap.h"
#include "flash_region.h"

#define PRINT_RAM_MEMMAP(name, NAME)           \
        hprintf("%p:%p RAM " #name "\n",       \
                NAME ## _START, NAME ## _END)

static int memmap_cmdfunc(int argc, char *argv[])
{
        int i;
        for (i=FlashRegionIdAll; i<FlashRegionIdMax; i++) {
		if (flash_region_get_size(i))
			hprintf("%p:%p FLA %s bf:8K bl:%s\n",
				flash_region_get_start_address(i),
				flash_region_get_end_address(i),
				flash_region_get_name(i),
				flash_region_get_blocking(i));
	}

        PRINT_RAM_MEMMAP(dram, DRAM);

	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

