#ifndef _HERMIT_TARGET_PLATFORM_BOARD_FX_H_
#define _HERMIT_TARGET_PLATFORM_BOARD_FX_H_

#include <mx3/ioregs.h>

#define MACH_NUMBER (1918)

static inline void
init_mux_private(void)
{
	/* Jumper */
	mxc_set_mux(MUX_PIN(xJP1), MUX_O_GPIO | MUX_I_GPIO);
	mxc_set_mux(MUX_PIN(xJP2), MUX_O_GPIO | MUX_I_GPIO);

	/* LED & BASE ID */
	mxc_set_mux(MUX_PIN(xLED_STATUS), MUX_O_GPIO | MUX_I_GPIO);

	/* LCD */
	mxc_set_mux(MUX_PIN(CONTRAST), MUX_O_FUNC | MUX_I_FUNC);

	/* GPIO */
#define P_CSI_GPIO (PAD_CTL_100K_PU | PAD_CTL_PUE_PUD | PAD_CTL_PKE_ENABLE)
	mxc_set_pad(PAD_PIN(CSI_D4), P_CSI_GPIO);
	mxc_set_pad(PAD_PIN(CSI_D5), P_CSI_GPIO);
#undef P_CSI_GPIO
}

static inline void
init_weim_private(void)
{
	/* CS3: smc921x */
	IO_WEIM(WORD, CSCR3U) = 0x00001800;
	IO_WEIM(WORD, CSCR3L) = 0xff00f5f1;
	IO_WEIM(WORD, CSCR3A) = 0x00ff0000;
}

static void
init_ipu(void)
{
	/* Set brightness (contrast) to zero */
	IO_IPU(WORD, SDC_PWM_CTRL) = 0x0;
}

static inline void
init_i2c(void)
{
	int i;
	u32 old_mux;

	old_mux = mxc_get_mux(MUX_PIN(CSPI2_MOSI));

	mxc_set_mux(MUX_PIN(CSPI2_MOSI), MUX_O_FUNC | MUX_I_FUNC);

	IO_CSPI2(WORD, CONREG) = 0x00071f0b;

	for (i=0; i<8; i++) {
		/* wait TxFIFO empty */
		while (!(IO_CSPI2(WORD, STATREG) & 0x0001));

		IO_CSPI2(WORD, TXDATA) = 0x55555555;
	}

	/* wait busy */
	while (!(IO_CSPI2(WORD, STATREG) & 0x0100));
	IO_CSPI2(WORD, STATREG) = 0x0100;

	IO_CSPI2(WORD, CONREG) = 0x0;

	mxc_set_mux(MUX_PIN(CSPI2_MOSI), old_mux);
}

static inline void
get_board_info_private(struct board_info *info)
{
	/* Jumper */
	mxc_set_gpio(GPIO_PIN(xJP1), GPIO_INPUT, 0);
	mxc_set_gpio(GPIO_PIN(xJP2), GPIO_INPUT, 0);

	info->jumper1 = mxc_get_gpio(GPIO_PIN(xJP1)) ? 0 : 1;
	info->jumper2 = mxc_get_gpio(GPIO_PIN(xJP2)) ? 0 : 1;
}

#define PRIVATE_LED_ON()	mxc_set_gpio(GPIO_PIN(xLED_STATUS), 1, 1)
#define PRIVATE_LED_OFF()	mxc_set_gpio(GPIO_PIN(xLED_STATUS), 1, 0)

#endif /* _HERMIT_TARGET_PLATFORM_BOARD_FX_H_ */
