/*
 * Copyright (c) 2003-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_AJ_MEMREGIONS_H
#define _HERMIT_AJ_MEMREGIONS_H

#if defined(ARMADILLOJ_STYPE)
#define FLASH_START       (0x02000000)
#define FLASH_SIZE	  (0x00200000)

#define RESERVED_START    (FLASH_START)
#define RESERVED_SIZE     (0x00020000)
#define reserved_blocking ("1x16K/l,2x8K/l,1x32K/l,1x64K/l")

#define HERMIT_START      (RESERVED_START + RESERVED_SIZE)
#define HERMIT_SIZE       (0x00020000)
#define hermit_blocking   ("2x64K/l")

#define USER_START        (HERMIT_START + HERMIT_SIZE)
#define USER_SIZE         (0x001C0000)
#define user_blocking     ("28x64K")

#define DRAM_START        (0x00000000)
#define DRAM_SIZE         (0x00800000)

#endif /* ARMADILLOJ_STYPE */

#if defined(ARMADILLOJ_CTYPE)
#define FLASH_START       (0x02000000)
#define FLASH_SIZE_2M     (0x00200000)
#define FLASH_SIZE_4M     (0x00400000)
#define FLASH_SIZE        (get_flash_size())

#define RESERVED_START    (FLASH_START)
#define RESERVED_SIZE     (0x00008000)

#define HERMIT_START      (RESERVED_START + RESERVED_SIZE)
#define HERMIT_SIZE       (0x00008000)

#define USER_START        (HERMIT_START + HERMIT_SIZE)
#define USER_SIZE_2M      (0x001F0000)
#define USER_SIZE_4M      (0x003F0000)
#define USER_SIZE         (get_user_size())

#define DRAM_START        (0x00000000)
#define DRAM_SIZE         (0x00800000)

#define USER_BLOCKS_2M    ("31x64K")
#define USER_BLOCKS_4M    ("63x64K")
#define user_blocking     (get_user_blocking())

#ifndef __ASSEMBLER__
unsigned int get_flash_size(void);
unsigned int get_user_size(void);
char *get_user_blocking(void);
#endif

#endif /* ARMADILLOJ_CTYPE */


#define LINUX_PARAM_SIZE	(0x00000f00)
#define LINUX_PARAM_ADDRESS	(0x00600000)

#define LINUX_SRC_SIZE          (USER_SIZE)
#define LINUX_SRC_ADDRESS       (USER_START)
#define LINUX_LOAD_ADDRESS	(DRAM_START)

#define INITRD_SRC_SIZE		(0x00200000)
#define INITRD_SRC_ADDRESS	(0)
#define INITRD_LOAD_ADDRESS	(DRAM_START + 0x00300000)

#ifndef __ASSEMBLER__
extern char __bss_end;
#endif

#define GUNZIP_MEM_SIZE 0x40000
#define GUNZIP_MEM_BASE (&__bss_end)

#endif /* _HERMIT_AJ_MEMREGIONS_H */

