/*
 * Copyright (c) 2000            Blue Mug, Inc.  All Rights Reserved.
 * Copyright (c) 2004-2005, 2007 Atmark Techno, Inc.  All Rights Reserved.
 */

#include <target/mem.h>
#include <target/herrno.h>
#include <target/io.h>
#include <target/scan.h>
#include <target/cache.h>
#include <target/gunzip.h>
#include <target/memzero.h>
#include <target/str.h>
#include "linux.h"
#include "memmap.h"
#include "mode.h"

/* for setting the root device */
#define MINORBITS       8
#define MKDEV(ma,mi)    (((ma) << MINORBITS) | (mi))

#define RAMDISK_MAJOR   1	/* major for "RAM disk" */
#define RAMDISK0_MINOR	0	/* b 1 0 == /dev/ram0 */

#define ROM_FLASH_MAJOR	31	/* major for "ROM/flash memory card" */
#define FLASH0_MINOR	16	/* b 31 16 == /dev/flash0 */
#define FLASH1_MINOR	17	/* b 31 17 == /dev/flash1 */

#define COMMAND_LINE_SIZE 512

char command_line[COMMAND_LINE_SIZE];

#if defined(__PPC__) || defined(__powerpc__)
/* 
 * we need board info struct for ppc. this is how we pass info from
 * bootloader to linux kernel in ppc arch. this structure must match
 * with bd_t in arch/ppc/platform/suzaku.h
 */
typedef struct board_info {
	unsigned int bi_memsize;	/* DRAM installed, in bytes */
	unsigned char bi_enetaddr[6];	/* FIXME: we don't need this */
	unsigned int bi_intfreq;	/* Processor speed, in Hz */
	unsigned int bi_busfreq;	/* Bus speed, in Hz */
	unsigned int bi_pci_busfreq;	/* PCI Bus speed, in Hz */

} bd_t;
bd_t bi_sz310 = {
        .bi_memsize = 1024 * 1024 * 32,     /*  32     MiB */
        .bi_intfreq = 3686400 * 18 * 4,     /* 265.4208MHz */
        .bi_busfreq = 3686400 * 18 * 4 / 4, /*  66.3552MHz */
};
bd_t bi_sz410 = {
        .bi_memsize = 1024 * 1024 * 64,     /*  64     MiB */
        .bi_intfreq = 100000000 * 7 / 2,    /* 350.0000MHz */
        .bi_busfreq = 100000000 * 7 / 8,    /*  87.5000MHz */
};
/*
 * Linux Kernel Parameters:
 *   r3: ptr to board info data
 *   r4: initrd_start or 0 if no initrd
 *   r5: initrd_end - unused if r4 is 0
 *   r6: Start of command line string
 *   r7: End   of command line string
 */
typedef void (*kernel_t)(bd_t *, unsigned long, unsigned long, unsigned long, unsigned long);
kernel_t kernel;

static inline void branch_to_kernel_image(char *cmdline)
{
        unsigned long bi_location;
	bd_t *bi;

	/* branch to kernel image */
        bi_location = (0x01000000 - sizeof(bd_t));
	if (is_flash_spi())
		bi = &bi_sz410;
	else
		bi = &bi_sz310;
        memcpy((bd_t *)bi_location, bi, sizeof(bd_t));
        kernel = (kernel_t)0;
        (*kernel)((bd_t*)bi_location, 0, 0, 0, 0);
}

#elif __MICROBLAZE__
static inline void branch_to_kernel_image(char *cmdline)
{
	/* branch to kernel image */
	__asm__ volatile (
                "	braid	%0		\n\t"   \
                "	addk	r5, r0, %1	\n\t"   \
                : /* none */
                : "i" (LINUX_LOAD_ADDRESS),
                  "r" (cmdline)
                : "r5");
}
#endif

static char * rebuild_flat_command_line(int argc, char *argv[])
{
        int i;
        char *p = command_line;
        for (i=1; i<argc; i++) {
                strcpy(p, argv[i]);
                p += strlen(argv[i]);
                *p = ' ';
        }
        *p = '\0';
        return command_line;
}

static int linux_cmdfunc(int argc, char *argv[])
{
        char * cmdline;

        cmdline = rebuild_flat_command_line(argc, argv);

        /* if we have some arguments, print it */
        if (*cmdline) {
                hprintf("Doing %s\n", cmdline);
        }

	branch_to_kernel_image(cmdline);
	/* never get here */
	return 0;
}

static int boot_cmdfunc(int argc, char *argv[])
{
#if defined(__PPC__) || defined(__powerpc__)
	__invalidate_dcache();
	__enable_dcache(0x80000000);
	__invalidate_icache();
	__enable_icache(0x80000000);
#elif __MICROBLAZE__
	unsigned int i;
	int cache_byte_size, cache_line_size;

	if (is_flash_spi()) {
		/* SZ130 */
		cache_byte_size = 8192;
		cache_line_size = 16;
	}
	else {
		/* SZ010, SZ030 */
		cache_byte_size = 8192;
		cache_line_size = 4;
	}
	for(i = 0; i < cache_byte_size; i += cache_line_size)
		__invalidate_icache(i);
	__enable_icache();
	if (is_flash_spi()) {
		/* SZ130 */
		cache_byte_size = 8192;
		cache_line_size = 16;
		for(i = 0; i < cache_byte_size; i += cache_line_size)
			__invalidate_dcache(i);
		__enable_dcache();
	}
#endif

	gunzip_object (" kernel", LINUX_SRC_ADDRESS, LINUX_LOAD_ADDRESS);

#if defined(__PPC__) || defined(__powerpc__)
	__disable_dcache();
	__disable_icache();
#elif __MICROBLAZE__
	__disable_icache();
	if (is_flash_spi()) {
		/* SZ130 */
		__disable_dcache();
	}
#endif
	
	linux_cmdfunc (argc, argv);

	return 0;
}

const command_t linux_command =
	{ "linux", "<linux options>", "start Linux", &linux_cmdfunc };
const command_t boot_command =
	{ "boot", "", "boot default Linux kernel and ramdisk", &boot_cmdfunc };
