/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_TARGET_COMMAND_H_
#define _HERMIT_TARGET_COMMAND_H_

#include <target/htypes.h>

typedef struct command command_t;
struct command {
	const char *name;
	const char *arghelp;
	const char *cmdhelp;
	int (*func)(int argc, char *argv[]);
};

typedef struct abbrev abbrev_t;
struct abbrev {
	const command_t *cmd;
	char abbrev;
};

typedef struct command_list command_list_t;
struct command_list {
	const command_t *const *commands;
	const abbrev_t *const *abbrevs;
	const char *prompt;
	command_list_t *prev;
};

/* keep command abbreviation declarations from getting messy */
#define ABBR(cmd,ab) \
        static const abbrev_t cmd##_abbrev = { &cmd, ab };

#if defined(COMMAND_NEW_ASSIGN)
#define __attribute_used__ __attribute__((__used__))
#define COMMAND(command) \
	static const command_t *__command_##command __attribute_used__ \
	__attribute__((__section__(".command.list"))) = &command

#define COMMAND_ABBR(command, key) \
	static const command_t *__command_##command __attribute_used__ \
	__attribute__((__section__(".command.list"))) = &command;\
	ABBR(command, key);\
	static const abbrev_t *__abbrev_##command __attribute_used__ \
	__attribute__((__section__(".command.abbrev"))) = &command##_abbrev

#else
#define COMMAND(command)
#define COMMAND_ABBR(command, key)
#endif

/* standard commands available for all targets */
extern const command_t download_command;
extern const command_t help_command;
extern const command_t jump_command;
extern const command_t peek_command;
extern const command_t peek8_command;
extern const command_t peek16_command;
extern const command_t peeknext_command;
extern const command_t poke_command;
extern const command_t poke8_command;
extern const command_t poke16_command;
extern const command_t quit_command;
extern const command_t upload_command;
extern const command_t version_command;

extern int do_command_loop(command_list_t *cmdlist);

extern const command_list_t *get_current_commands(void);

/*
 * Error handling.  We would just use an error string, but sometimes
 * you don't want to allocate such buffers in really tight memory
 * situations, so we provide an option; if 'errfunc' is set, call it
 * instead of just printing errmsg.
 */
extern void (*errfunc)(void);
extern union errdata {
	const char *msg;
	word_t word;
} errdata;

#endif /* _HERMIT_TARGET_COMMAND_H_ */
