/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private InputStream in;
    private long position;
    private final long limit;
    private long markPosition;

    public LimitedInputStream(InputStream inputStream, long l) {
        if (inputStream == null || 0L > l) {
            if (inputStream == null) {
                throw new NullPointerException("in");
            }
            throw new IllegalArgumentException("limit must be 0 or more.");
        }
        this.in = inputStream;
        this.position = 0L;
        this.limit = l;
        this.markPosition = -1L;
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.limit) {
            int n = this.in.read();
            if (0 <= n) {
                ++this.position;
            }
            return n;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (0 < byArray.length) {
            int n;
            if ((long)byArray.length < this.limit - this.position) {
                n = this.in.read(byArray);
            } else if (this.position < this.limit) {
                n = this.in.read(byArray, 0, (int)(this.limit - this.position));
            } else {
                return -1;
            }
            if (0 < n) {
                this.position += (long)n;
            }
            return n;
        }
        return 0;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (0 < n2) {
            int n3;
            if (this.limit <= this.position) {
                return -1;
            }
            if (this.limit - this.position < (long)n2) {
                n2 = (int)(this.limit - this.position);
            }
            if (0 < (n3 = this.in.read(byArray, n, n2))) {
                this.position += (long)n3;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public long skip(long l) throws IOException {
        if (0L < l) {
            if (this.limit <= this.position) {
                return 0L;
            }
            if (this.limit - this.position < l) {
                l = this.limit - this.position;
            }
            if (0L < (l = this.in.skip(l))) {
                this.position += l;
            }
            return l;
        }
        return 0L;
    }

    @Override
    public void mark(int n) {
        this.in.mark(n);
        this.markPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("not support mark()/reset().");
        }
        if (this.markPosition < 0L) {
            throw new IOException("not marked.");
        }
        this.in.reset();
        this.position = this.markPosition;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.limit - this.position);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }
}

