/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.gr.java_conf.dangan.lang.reflect.Type;

public class MethodUtil {
    private MethodUtil() {
    }

    public static Object invoke(Object object, String string, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = object.getClass();
        Method method = MethodUtil.getMatchFullInstanceMethod(clazz, string, objectArray);
        if (method == null && (method = MethodUtil.getInstanceMethod(clazz, string, objectArray)) != null) {
            objectArray = Type.parseAll(method.getParameterTypes(), objectArray);
        }
        if (method != null) {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Object invokeStatic(String string, String string2, Object[] objectArray) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        return MethodUtil.invokeStatic(Class.forName(string), string2, objectArray);
    }

    public static Object invokeStatic(Class clazz, String string, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException {
        Method method = MethodUtil.getMatchFullStaticMethod(clazz, string, objectArray);
        if (method == null && (method = MethodUtil.getStaticMethod(clazz, string, objectArray)) != null) {
            objectArray = Type.parseAll(method.getParameterTypes(), objectArray);
        }
        if (method != null) {
            try {
                return method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Method getInstanceMethod(String string, String string2, Object[] objectArray) throws ClassNotFoundException {
        return MethodUtil.getInstanceMethod(Class.forName(string), string2, objectArray, false);
    }

    public static Method getInstanceMethod(Class clazz, String string, Object[] objectArray) {
        return MethodUtil.getInstanceMethod(clazz, string, objectArray, false);
    }

    public static Method getInstanceMethod(String string, String string2, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return MethodUtil.getInstanceMethod(Class.forName(string), string2, objectArray, bl);
    }

    public static Method getInstanceMethod(Class clazz, String string, Object[] objectArray, boolean bl) {
        int n;
        Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchFullAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchRestrictAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        return null;
    }

    public static Method getMatchFullInstanceMethod(String string, String string2, Object[] objectArray) throws ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod(Class.forName(string), string2, objectArray, false);
    }

    public static Method getMatchFullInstanceMethod(Class clazz, String string, Object[] objectArray) {
        return MethodUtil.getMatchFullInstanceMethod(clazz, string, objectArray, false);
    }

    public static Method getMatchFullInstanceMethod(String string, String string2, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return MethodUtil.getMatchFullInstanceMethod(Class.forName(string), string2, objectArray, bl);
    }

    public static Method getMatchFullInstanceMethod(Class clazz, String string, Object[] objectArray, boolean bl) {
        Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || Modifier.isStatic(methodArray[i].getModifiers()) || !Type.matchFullAll(methodArray[i].getParameterTypes(), objectArray)) continue;
            return methodArray[i];
        }
        return null;
    }

    public static Method getStaticMethod(String string, String string2, Object[] objectArray) throws ClassNotFoundException {
        return MethodUtil.getStaticMethod(Class.forName(string), string2, objectArray, false);
    }

    public static Method getStaticMethod(Class clazz, String string, Object[] objectArray) {
        return MethodUtil.getStaticMethod(clazz, string, objectArray, false);
    }

    public static Method getStaticMethod(String string, String string2, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return MethodUtil.getStaticMethod(Class.forName(string), string2, objectArray, bl);
    }

    public static Method getStaticMethod(Class clazz, String string, Object[] objectArray, boolean bl) {
        int n;
        Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || !Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchFullAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || !Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchRestrictAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string) || !Modifier.isStatic(methodArray[n].getModifiers()) || !Type.matchAll(methodArray[n].getParameterTypes(), objectArray)) continue;
            return methodArray[n];
        }
        return null;
    }

    public static Method getMatchFullStaticMethod(String string, String string2, Object[] objectArray) throws ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod(Class.forName(string), string2, objectArray, false);
    }

    public static Method getMatchFullStaticMethod(Class clazz, String string, Object[] objectArray) {
        return MethodUtil.getMatchFullStaticMethod(clazz, string, objectArray, false);
    }

    public static Method getMatchFullStaticMethod(String string, String string2, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return MethodUtil.getMatchFullStaticMethod(Class.forName(string), string2, objectArray, bl);
    }

    public static Method getMatchFullStaticMethod(Class clazz, String string, Object[] objectArray, boolean bl) {
        Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || !Modifier.isStatic(methodArray[i].getModifiers()) || !Type.matchFullAll(methodArray[i].getParameterTypes(), objectArray)) continue;
            return methodArray[i];
        }
        return null;
    }
}

