/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util;

import java.util.Date;

public class WindowsDate
extends Date
implements Cloneable {
    public static final long TIME_DIFFERENCE = 116444736000000000L;
    private int NanoSecounds;

    public WindowsDate() {
        this.NanoSecounds = 0;
        this.checkRange();
    }

    public WindowsDate(Date date) {
        super(date.getTime());
        if (date instanceof WindowsDate) {
            this.NanoSecounds = ((WindowsDate)date).NanoSecounds;
        } else {
            this.NanoSecounds = 0;
            this.checkRange();
        }
    }

    public WindowsDate(long l) {
        super(0L <= l ? (l - 116444736000000000L) / 10000L : ((l >>> 1) - 58222368000000000L) / 5000L);
        this.NanoSecounds = (int)((l >>> 1) % 5000L * 2L + (l & 1L)) * 100;
    }

    @Override
    public Object clone() {
        return new WindowsDate(this);
    }

    @Override
    public void setYear(int n) {
        long l = this.getTime();
        try {
            super.setYear(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setMonth(int n) {
        long l = this.getTime();
        try {
            super.setMonth(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setDate(int n) {
        long l = this.getTime();
        try {
            super.setDate(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setHours(int n) {
        long l = this.getTime();
        try {
            super.setHours(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setMinutes(int n) {
        long l = this.getTime();
        try {
            super.setMinutes(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setSeconds(int n) {
        long l = this.getTime();
        try {
            super.setSeconds(n);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l);
            throw illegalArgumentException;
        }
    }

    @Override
    public void setTime(long l) {
        long l2 = this.getTime();
        try {
            super.setTime(l);
            this.checkRange();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setTime(l2);
            throw illegalArgumentException;
        }
    }

    public void setWindowsTime(long l) {
        super.setTime(0L <= l ? (l - 116444736000000000L) / 10000L : ((l >>> 1) - 58222368000000000L) / 5000L);
        this.NanoSecounds = (int)((l >>> 1) % 5000L * 2L + (l & 1L)) * 100;
    }

    public long getWindowsTime() {
        return super.getTime() * 10000L + 116444736000000000L + (long)(this.NanoSecounds / 100);
    }

    private void checkRange() {
        long l = super.getTime();
        if (-933981677285477L > l || l > 1833029933770955L) {
            throw new IllegalArgumentException("outside of range of Windows FILETIME format. ");
        }
    }
}

