/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.HashShort;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class HashAndBinaryTreeSearch
implements LzssSearchMethod {
    private static final int UNUSED = -1;
    private static final int ROOT_NODE = -2;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private int[] parent;
    private int[] small;
    private int[] large;
    private int[] dummy;

    private HashAndBinaryTreeSearch() {
    }

    public HashAndBinaryTreeSearch(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, HashShort.class.getName());
    }

    public HashAndBinaryTreeSearch(int n, int n2, int n3, byte[] byArray, String string) {
        int n4;
        this.DictionarySize = n;
        this.MaxMatch = n2;
        this.Threshold = n3;
        this.TextBuffer = byArray;
        this.DictionaryLimit = this.DictionarySize;
        try {
            this.hashMethod = (HashMethod)Factory.createInstance(string, new Object[]{byArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException.getTargetException().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
        this.hashTable = new int[this.hashMethod.tableSize()];
        for (n4 = 0; n4 < this.hashTable.length; ++n4) {
            this.hashTable[n4] = -1;
        }
        this.parent = new int[n];
        this.large = new int[n];
        this.small = new int[n];
        for (n4 = 0; n4 < this.parent.length; ++n4) {
            this.parent[n4] = -1;
        }
    }

    @Override
    public void put(int n) {
        this.deleteNode(n - this.DictionarySize);
        int n2 = this.hashMethod.hash(n);
        int n3 = this.hashTable[n2];
        int n4 = this.hashTable[n2];
        byte[] byArray = this.TextBuffer;
        int n5 = n + this.MaxMatch;
        int n6 = 0;
        int n7 = 0;
        while (n4 != -1) {
            n7 = n4;
            n6 = n;
            while (byArray[n7] == byArray[n6]) {
                ++n7;
                if (n5 > ++n6) continue;
                this.replaceNode(n4, n);
                return;
            }
            n3 = n4;
            n4 = byArray[n7] < byArray[n6] ? this.large[n4 & this.DictionarySize - 1] : this.small[n4 & this.DictionarySize - 1];
        }
        if (this.hashTable[n2] != -1) {
            this.addNode(n3, n, n6 - n);
        } else {
            this.hashTable[n2] = n;
            int n8 = n & this.DictionarySize - 1;
            this.parent[n8] = -2;
            this.small[n8] = -1;
            this.large[n8] = -1;
        }
    }

    @Override
    public int searchAndPut(int n) {
        this.deleteNode(n - this.DictionarySize);
        int n2 = this.hashMethod.hash(n);
        int n3 = -1;
        int n4 = this.hashTable[n2];
        int n5 = this.hashTable[n2];
        int n6 = this.hashTable[n2];
        byte[] byArray = this.TextBuffer;
        int n7 = n + this.MaxMatch;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n6 != -1) {
            n9 = n6;
            n8 = n;
            while (byArray[n9] == byArray[n8]) {
                ++n9;
                if (n7 > ++n8) continue;
                this.replaceNode(n4, n);
                return LzssOutputStream.createSearchReturn(n3, n4);
            }
            n10 = n8 - n;
            if (n3 < n10) {
                n4 = n6;
                n3 = n10;
            } else if (n3 == n10 && n4 < n6) {
                n4 = n6;
            }
            n5 = n6;
            n6 = byArray[n9] < byArray[n8] ? this.large[n6 & this.DictionarySize - 1] : this.small[n6 & this.DictionarySize - 1];
        }
        if (this.hashTable[n2] != -1) {
            this.addNode(n5, n, n10);
        } else {
            this.hashTable[n2] = n;
            int n11 = n & this.DictionarySize - 1;
            this.parent[n11] = -2;
            this.small[n11] = -1;
            this.large[n11] = -1;
        }
        n6 = n - this.DictionarySize;
        if (this.DictionaryLimit <= n6) {
            n10 = 0;
            while (this.TextBuffer[n6 + n10] == this.TextBuffer[n + n10] && this.MaxMatch > ++n10) {
            }
            if (n3 < n10) {
                n4 = n6;
                n3 = n10;
            }
        }
        if (this.Threshold <= n3) {
            return LzssOutputStream.createSearchReturn(n3, n4);
        }
        return -1;
    }

    @Override
    public int search(int n, int n2) {
        int n3;
        int n4 = this.Threshold - 1;
        int n5 = n;
        int n6 = Math.max(this.DictionaryLimit, n2);
        byte[] byArray = this.TextBuffer;
        int n7 = Math.min(this.TextBuffer.length, n + this.MaxMatch);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (n3 = n - 1; n6 < n3; --n3) {
            n8 = n3;
            n9 = n;
            while (byArray[n8] == byArray[n9]) {
                ++n8;
                if (n7 > ++n9) continue;
            }
            if (n4 >= n10) continue;
            n5 = n3;
            n4 = n10;
        }
        if (this.hashMethod.hashRequires() <= this.TextBuffer.length - n) {
            int n11 = this.hashMethod.hash(n);
            n3 = this.hashTable[n11];
            n6 = Math.max(this.DictionaryLimit, n - this.DictionarySize);
            while (n3 != -1) {
                n8 = n3;
                n9 = n;
                while (byArray[n8] == byArray[n9]) {
                    ++n8;
                    if (n7 > ++n9) continue;
                }
                if (n9 >= n7) break;
                n10 = n9 - n;
                if (n6 <= n3) {
                    if (n4 < n10) {
                        n5 = n3;
                        n4 = n10;
                    } else if (n4 == n10 && n5 < n3) {
                        n5 = n3;
                    }
                }
                n3 = byArray[n8] < byArray[n9] ? this.large[n3 & this.DictionarySize - 1] : this.small[n3 & this.DictionarySize - 1];
            }
        }
        if (this.Threshold <= n4) {
            return LzssOutputStream.createSearchReturn(n4, n5);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.slideTree(this.hashTable);
        this.slideTree(this.parent);
        this.slideTree(this.small);
        this.slideTree(this.large);
    }

    @Override
    public int putRequires() {
        return this.MaxMatch;
    }

    private void addNode(int n, int n2, int n3) {
        int n4 = n & this.DictionarySize - 1;
        int n5 = n2 & this.DictionarySize - 1;
        if (this.TextBuffer[n + n3] < this.TextBuffer[n2 + n3]) {
            this.large[n4] = n2;
        } else {
            this.small[n4] = n2;
        }
        this.parent[n5] = n;
        this.small[n5] = -1;
        this.large[n5] = -1;
    }

    private void deleteNode(int n) {
        int n2 = n & this.DictionarySize - 1;
        if (this.parent[n2] != -1) {
            if (this.small[n2] == -1 && this.large[n2] == -1) {
                this.contractNode(n, -1);
            } else if (this.small[n2] == -1) {
                this.contractNode(n, this.large[n2]);
            } else if (this.large[n2] == -1) {
                this.contractNode(n, this.small[n2]);
            } else {
                int n3 = this.findNext(n);
                this.deleteNode(n3);
                this.replaceNode(n, n3);
            }
        }
    }

    private void contractNode(int n, int n2) {
        int n3 = n & this.DictionarySize - 1;
        int n4 = n2 & this.DictionarySize - 1;
        int n5 = this.parent[n3];
        int n6 = n5 & this.DictionarySize - 1;
        if (n5 != -2) {
            if (n == this.small[n6]) {
                this.small[n6] = n2;
            } else {
                this.large[n6] = n2;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)n)] = n2;
        }
        if (n2 != -1) {
            this.parent[n4] = n5;
        }
        this.parent[n3] = -1;
    }

    private void replaceNode(int n, int n2) {
        int n3 = n & this.DictionarySize - 1;
        int n4 = n2 & this.DictionarySize - 1;
        int n5 = this.parent[n3];
        int n6 = n5 & this.DictionarySize - 1;
        if (n5 != -2) {
            if (n == this.small[n6]) {
                this.small[n6] = n2;
            } else {
                this.large[n6] = n2;
            }
        } else {
            this.hashTable[this.hashMethod.hash((int)n)] = n2;
        }
        this.parent[n4] = n5;
        this.small[n4] = this.small[n3];
        this.large[n4] = this.large[n3];
        if (this.small[n4] != -1) {
            this.parent[this.small[n4] & this.DictionarySize - 1] = n2;
        }
        if (this.large[n4] != -1) {
            this.parent[this.large[n4] & this.DictionarySize - 1] = n2;
        }
        this.parent[n3] = -1;
        this.large[n3] = -1;
        this.small[n3] = -1;
    }

    private int findNext(int n) {
        int n2 = n & this.DictionarySize - 1;
        n = this.small[n2];
        n2 = n & this.DictionarySize - 1;
        while (-1 != this.large[n2]) {
            n = this.large[n2];
            n2 = n & this.DictionarySize - 1;
        }
        return n;
    }

    private void slideTree(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0 <= nArray[i] ? nArray[i] - this.DictionarySize : nArray[i];
        }
    }
}

