/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaImmediateOutputStream
extends OutputStream {
    private RandomAccessFile archive;
    private OutputStream out;
    private LhaHeader header;
    private String encoding;
    private long headerpos;
    private CRC16 crc;
    private Properties property;

    private LhaImmediateOutputStream() {
    }

    public LhaImmediateOutputStream(String string) throws FileNotFoundException {
        if (string == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaImmediateOutputStream(String string, Properties properties) throws FileNotFoundException {
        if (string == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaImmediateOutputStream(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaImmediateOutputStream(File file, Properties properties) throws IOException {
        if (file == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaImmediateOutputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new NullPointerException("out");
        }
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaImmediateOutputStream(RandomAccessFile randomAccessFile, Properties properties) {
        if (randomAccessFile == null || properties == null) {
            if (randomAccessFile == null) {
                throw new NullPointerException("null");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(randomAccessFile, properties);
    }

    private void constructerHelper(RandomAccessFile randomAccessFile, Properties properties) {
        this.archive = randomAccessFile;
        this.out = null;
        this.header = null;
        this.headerpos = -1L;
        this.crc = new CRC16();
        this.property = properties;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(n);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(byArray, n, n2);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("no entry");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.closeEntry();
        }
        this.archive.write(0);
        try {
            this.archive.setLength(this.archive.getFilePointer());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.archive.close();
        this.archive = null;
        this.crc = null;
        this.property = null;
        this.encoding = null;
    }

    public void putNextEntry(LhaHeader lhaHeader) throws IOException {
        if (lhaHeader.getCompressedSize() == -1L || lhaHeader.getCRC() == -1) {
            this.putNextEntryNotYetCompressed(lhaHeader);
        } else {
            this.putNextEntryAlreadyCompressed(lhaHeader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putNextEntryAlreadyCompressed(LhaHeader lhaHeader) throws IOException {
        if (this.out != null) throw new IllegalStateException("entry is not closed.");
        if (lhaHeader.getOriginalSize() != -1L && lhaHeader.getCompressedSize() != -1L && lhaHeader.getCRC() != -1) {
            this.headerpos = this.archive.getFilePointer();
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (lhaHeader.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (lhaHeader.getCompressedSize() != -1L) throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
            throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(lhaHeader.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, lhaHeader.getCompressedSize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putNextEntryNotYetCompressed(LhaHeader lhaHeader) throws IOException {
        if (this.out != null) throw new IllegalStateException("entry is not closed.");
        if (lhaHeader.getOriginalSize() == -1L) throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
        this.crc.reset();
        this.headerpos = this.archive.getFilePointer();
        this.header = (LhaHeader)lhaHeader.clone();
        this.header.setCompressedSize(0L);
        this.header.setCRC(0);
        this.encoding = this.property.getProperty("lha.encoding");
        if (this.encoding == null) {
            this.encoding = LhaProperty.getProperty("lha.encoding");
        }
        this.archive.write(this.header.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, lhaHeader.getOriginalSize());
        this.out = CompressMethod.connectEncoder(this.out, lhaHeader.getCompressMethod(), this.property);
    }

    public boolean closeEntry() throws IOException {
        if (this.out != null) {
            this.out.close();
            if (this.header != null) {
                long l = this.archive.getFilePointer();
                long l2 = l - this.headerpos - (long)this.header.getBytes(this.encoding).length;
                this.header.setCompressedSize(l2);
                if (this.header.getCRC() != -2) {
                    this.header.setCRC((int)this.crc.getValue());
                }
                this.archive.seek(this.headerpos);
                if (this.header.getCompressMethod().equals("-lh0-") || this.header.getCompressMethod().equals("-lhd-") || this.header.getCompressMethod().equals("-lz4-") || this.header.getCompressedSize() < this.header.getOriginalSize()) {
                    this.archive.write(this.header.getBytes(this.encoding));
                    this.archive.seek(l);
                    this.header = null;
                    this.out = null;
                    return true;
                }
                this.header = null;
                this.out = null;
                return false;
            }
            this.out = null;
            return true;
        }
        return true;
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private RandomAccessFile archive;
        private long pos;
        private long limit;

        public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.archive = randomAccessFile;
            this.pos = this.archive.getFilePointer();
            this.limit = this.pos + l;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.pos < this.limit) {
                ++this.pos;
                this.archive.write(n);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit < this.pos + (long)n2) {
                n2 = (int)Math.max(this.limit - this.pos, 0L);
            }
            this.archive.write(byArray, n, n2);
            this.pos += (long)n2;
        }

        @Override
        public void close() {
            this.archive = null;
        }
    }
}

