/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import jp.gr.java_conf.dangan.io.GrowthByteBuffer;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaOutputStream
extends OutputStream {
    private OutputStream out;
    private CRC16 crc;
    private Temporary temp;
    private LhaHeader header;
    private OutputStream tempOut;
    private long length;
    private Properties property;

    private LhaOutputStream() {
    }

    public LhaOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(outputStream, new TemporaryBuffer(), properties);
    }

    public LhaOutputStream(OutputStream outputStream, Properties properties) {
        if (outputStream == null || properties == null) {
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(outputStream, new TemporaryBuffer(), properties);
    }

    public LhaOutputStream(OutputStream outputStream, RandomAccessFile randomAccessFile) {
        if (outputStream == null || randomAccessFile == null) {
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            throw new NullPointerException("file");
        }
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(outputStream, new TemporaryFile(randomAccessFile), properties);
    }

    public LhaOutputStream(OutputStream outputStream, RandomAccessFile randomAccessFile, Properties properties) {
        if (outputStream == null || randomAccessFile == null || properties == null) {
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            if (randomAccessFile == null) {
                throw new NullPointerException("file");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(outputStream, new TemporaryFile(randomAccessFile), properties);
    }

    private void constructerHelper(OutputStream outputStream, Temporary temporary, Properties properties) {
        this.out = outputStream;
        this.temp = temporary;
        this.property = properties;
        this.crc = new CRC16();
        this.header = null;
        this.tempOut = null;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.tempOut != null) {
            if (this.header != null) {
                this.crc.update(n);
            }
            this.tempOut.write(n);
            ++this.length;
        } else {
            throw new IOException("no entry");
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.tempOut != null) {
            if (this.header != null) {
                this.crc.update(byArray, n, n2);
            }
            this.tempOut.write(byArray, n, n2);
            this.length += (long)n2;
        } else {
            throw new IOException("no entry");
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.tempOut != null) {
            this.tempOut.flush();
        }
        if (this.tempOut != this.out) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tempOut != null) {
            this.closeEntry();
        }
        this.out.write(0);
        this.out.close();
        this.out = null;
        this.temp.close();
        this.temp = null;
        this.property = null;
        this.crc = null;
        this.header = null;
    }

    public void putNextEntry(LhaHeader lhaHeader) throws IOException {
        if (lhaHeader.getCompressedSize() == -1L || lhaHeader.getOriginalSize() == -1L || lhaHeader.getCRC() == -1) {
            this.putNextEntryNotYetCompressed(lhaHeader);
        } else {
            this.putNextEntryAlreadyCompressed(lhaHeader);
        }
    }

    public void putNextEntryAlreadyCompressed(LhaHeader lhaHeader) throws IOException {
        String string;
        if (lhaHeader.getOriginalSize() != -1L && lhaHeader.getCompressedSize() != -1L && lhaHeader.getCRC() != -1) {
            if (this.tempOut != null) {
                this.closeEntry();
            }
            if ((string = this.property.getProperty("lha.encoding")) == null) {
                string = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (lhaHeader.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (lhaHeader.getCompressedSize() == -1L) {
                throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
            }
            throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
        }
        this.out.write(lhaHeader.getBytes(string));
        this.tempOut = this.out;
    }

    public void putNextEntryNotYetCompressed(LhaHeader lhaHeader) throws IOException {
        if (this.tempOut != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.length = 0L;
        this.header = (LhaHeader)lhaHeader.clone();
        this.tempOut = CompressMethod.connectEncoder(this.temp.getOutputStream(), lhaHeader.getCompressMethod(), this.property);
    }

    public void closeEntry() throws IOException {
        if (this.header != null) {
            int n;
            String string;
            InputStream inputStream;
            this.tempOut.close();
            if (this.temp.length() < this.length) {
                this.header.setOriginalSize(this.length);
                this.header.setCompressedSize(this.temp.length());
                this.header.setCRC((int)this.crc.getValue());
                inputStream = this.temp.getInputStream();
            } else {
                string = this.header.getCompressMethod();
                this.header.setOriginalSize(this.length);
                this.header.setCompressedSize(this.length);
                this.header.setCRC((int)this.crc.getValue());
                if (!this.header.getCompressMethod().equalsIgnoreCase("-lhd-")) {
                    this.header.setCompressMethod("-lh0-");
                }
                inputStream = this.temp.getInputStream();
                inputStream = CompressMethod.connectDecoder(inputStream, string, this.property, this.temp.length());
            }
            string = this.property.getProperty("lha.encoding");
            if (string == null) {
                string = LhaProperty.getProperty("lha.encoding");
            }
            this.out.write(this.header.getBytes(string));
            byte[] byArray = new byte[8192];
            while (0 <= (n = inputStream.read(byArray))) {
                this.out.write(byArray, 0, n);
            }
        }
        this.header = null;
        this.tempOut = null;
    }

    private static class TemporaryBuffer
    implements Temporary {
        private GrowthByteBuffer tempbuffer = new GrowthByteBuffer();

        @Override
        public InputStream getInputStream() {
            return new TemporaryBufferInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return new TemporaryBufferOutputStream();
        }

        @Override
        public long length() {
            return this.tempbuffer.length();
        }

        @Override
        public void close() {
            this.tempbuffer = null;
        }

        private class TemporaryBufferOutputStream
        extends OutputStream {
            public TemporaryBufferOutputStream() {
                TemporaryBuffer.this.tempbuffer.seek(0);
                TemporaryBuffer.this.tempbuffer.setLength(0);
            }

            @Override
            public void write(int n) {
                TemporaryBuffer.this.tempbuffer.write(n);
            }

            @Override
            public void write(byte[] byArray) {
                TemporaryBuffer.this.tempbuffer.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                TemporaryBuffer.this.tempbuffer.write(byArray, n, n2);
            }
        }

        private class TemporaryBufferInputStream
        extends InputStream {
            public TemporaryBufferInputStream() {
                TemporaryBuffer.this.tempbuffer.seek(0);
            }

            @Override
            public int read() {
                return TemporaryBuffer.this.tempbuffer.read();
            }

            @Override
            public int read(byte[] byArray) {
                return TemporaryBuffer.this.tempbuffer.read(byArray);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                return TemporaryBuffer.this.tempbuffer.read(byArray, n, n2);
            }
        }
    }

    private static class TemporaryFile
    implements Temporary {
        private RandomAccessFile tempfile;
        private long length;

        public TemporaryFile(RandomAccessFile randomAccessFile) {
            if (randomAccessFile == null) {
                throw new NullPointerException("file");
            }
            this.tempfile = randomAccessFile;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new TemporaryFileInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new TemporaryFileOutputStream();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.tempfile.close();
            this.tempfile = null;
        }

        private class TemporaryFileOutputStream
        extends OutputStream {
            public TemporaryFileOutputStream() throws IOException {
                TemporaryFile.this.tempfile.seek(0L);
                TemporaryFile.this.length = 0L;
            }

            @Override
            public void write(int n) throws IOException {
                TemporaryFile.this.tempfile.write(n);
                TemporaryFile.this.length++;
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                TemporaryFile.this.tempfile.write(byArray);
                TemporaryFile.this.length += byArray.length;
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                TemporaryFile.this.tempfile.write(byArray, n, n2);
                TemporaryFile.this.length += n2;
            }
        }

        private class TemporaryFileInputStream
        extends InputStream {
            public TemporaryFileInputStream() throws IOException {
                TemporaryFile.this.tempfile.seek(0L);
            }

            @Override
            public int read() throws IOException {
                long l;
                long l2 = TemporaryFile.this.tempfile.getFilePointer();
                if (l2 < (l = TemporaryFile.this.length)) {
                    return TemporaryFile.this.tempfile.read();
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                long l = TemporaryFile.this.tempfile.getFilePointer();
                long l2 = TemporaryFile.this.length;
                n2 = (int)(Math.min(l + (long)n2, l2) - l);
                if (l < l2) {
                    return TemporaryFile.this.tempfile.read(byArray, n, n2);
                }
                return -1;
            }
        }
    }

    private static interface Temporary {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public long length() throws IOException;

        public void close() throws IOException;
    }
}

