/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.Vector;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaRetainedOutputStream
extends OutputStream {
    private RandomAccessFile archive;
    private OutputStream out;
    private RandomAccessFileOutputStream rafo;
    private LhaHeader header;
    private String encoding;
    private long headerpos;
    private CRC16 crc;
    private Properties property;

    private LhaRetainedOutputStream() {
    }

    public LhaRetainedOutputStream(String string) throws FileNotFoundException {
        if (string == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaRetainedOutputStream(String string, Properties properties) throws FileNotFoundException {
        if (string == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaRetainedOutputStream(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaRetainedOutputStream(File file, Properties properties) throws IOException {
        if (file == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaRetainedOutputStream(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            throw new NullPointerException("out");
        }
        Properties properties = LhaProperty.getProperties();
        this.constructerHelper(randomAccessFile, properties);
    }

    public LhaRetainedOutputStream(RandomAccessFile randomAccessFile, Properties properties) {
        if (randomAccessFile == null || properties == null) {
            if (randomAccessFile == null) {
                throw new NullPointerException("null");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(randomAccessFile, properties);
    }

    private void constructerHelper(RandomAccessFile randomAccessFile, Properties properties) {
        this.archive = randomAccessFile;
        this.out = null;
        this.header = null;
        this.headerpos = -1L;
        this.crc = new CRC16();
        this.property = properties;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(n);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(byArray, n, n2);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("no entry");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.closeEntry();
        }
        this.archive.write(0);
        try {
            this.archive.setLength(this.archive.getFilePointer());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.archive.close();
        this.archive = null;
        this.header = null;
        this.crc = null;
        this.property = null;
        this.rafo = null;
    }

    public void putNextEntry(LhaHeader lhaHeader) throws IOException {
        if (lhaHeader.getCompressedSize() == -1L || lhaHeader.getCRC() == -1) {
            this.putNextEntryNotYetCompressed(lhaHeader);
        } else {
            this.putNextEntryAlreadyCompressed(lhaHeader);
        }
    }

    public void putNextEntryAlreadyCompressed(LhaHeader lhaHeader) throws IOException {
        if (lhaHeader.getOriginalSize() != -1L && lhaHeader.getCompressedSize() != -1L && lhaHeader.getCRC() != -1) {
            if (this.out != null) {
                this.closeEntry();
            }
            this.headerpos = this.archive.getFilePointer();
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (lhaHeader.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (lhaHeader.getCompressedSize() == -1L) {
                throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
            }
            throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(lhaHeader.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, lhaHeader.getCompressedSize());
    }

    public void putNextEntryNotYetCompressed(LhaHeader lhaHeader) throws IOException {
        if (lhaHeader.getOriginalSize() != -1L) {
            if (this.out != null) {
                this.closeEntry();
            }
            this.crc.reset();
            this.headerpos = this.archive.getFilePointer();
            this.header = (LhaHeader)lhaHeader.clone();
            this.header.setCompressedSize(0L);
            this.header.setCRC(0);
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(this.header.getBytes(this.encoding));
        this.rafo = new RandomAccessFileOutputStream(this.archive, lhaHeader.getOriginalSize());
        this.out = CompressMethod.connectEncoder(this.rafo, lhaHeader.getCompressMethod(), this.property);
    }

    public void closeEntry() throws IOException {
        if (this.header != null) {
            long l;
            this.out.close();
            if (!this.rafo.cache.isEmpty()) {
                int n;
                l = this.rafo.start;
                RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(this.archive, this.rafo);
                InputStream inputStream = CompressMethod.connectDecoder(randomAccessFileInputStream, this.header.getCompressMethod(), this.property, this.header.getOriginalSize());
                byte[] byArray = new byte[8192];
                while (0 <= (n = inputStream.read(byArray))) {
                    randomAccessFileInputStream.cache(l + (long)n);
                    this.archive.seek(l);
                    this.archive.write(byArray, 0, n);
                    l += (long)n;
                }
                inputStream.close();
                this.header.setCompressMethod("-lh0-");
            }
            long l2 = this.archive.getFilePointer();
            l = l2 - this.headerpos - (long)this.header.getBytes(this.encoding).length;
            this.header.setCompressedSize(l);
            if (this.header.getCRC() != -2) {
                this.header.setCRC((int)this.crc.getValue());
            }
            this.archive.seek(this.headerpos);
            this.archive.write(this.header.getBytes(this.encoding));
            this.archive.seek(l2);
        }
        this.header = null;
        this.out = null;
    }

    private static class Cache {
        private Vector cache = new Vector();
        private byte[] current = null;
        private int position = 0;

        public int read() {
            if (null != this.current) {
                int n = this.current[this.position++] & 0xFF;
                if (this.current.length <= this.position) {
                    if (0 < this.cache.size()) {
                        this.current = (byte[])this.cache.firstElement();
                        this.cache.removeElementAt(0);
                    } else {
                        this.current = null;
                    }
                    this.position = 0;
                }
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) {
            int n3 = 0;
            while (null != this.current && n3 < n2) {
                int n4 = Math.min(this.current.length - this.position, n2 - n3);
                System.arraycopy(this.current, this.position, byArray, n + n3, n4);
                this.position += n4;
                n3 += n4;
                if (this.current.length > this.position) continue;
                if (0 < this.cache.size()) {
                    this.current = (byte[])this.cache.firstElement();
                    this.cache.removeElementAt(0);
                } else {
                    this.current = null;
                }
                this.position = 0;
            }
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }

        public void add(byte[] byArray) {
            if (this.current == null) {
                this.current = byArray;
            } else {
                this.cache.addElement(byArray);
            }
        }

        public void add(byte[] byArray, int n, int n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (this.current == null) {
                this.current = byArray2;
            } else {
                this.cache.addElement(byArray2);
            }
        }

        public boolean isEmpty() {
            return this.current == null;
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private RandomAccessFile archive;
        private Cache front;
        private Cache rear;
        private long pos;
        private long limit;

        public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, RandomAccessFileOutputStream randomAccessFileOutputStream) {
            this.archive = randomAccessFile;
            this.pos = randomAccessFileOutputStream.start;
            this.limit = randomAccessFileOutputStream.pos;
            this.front = new Cache();
            this.rear = randomAccessFileOutputStream.cache;
        }

        @Override
        public int read() throws IOException {
            int n = this.front.read();
            if (n < 0) {
                if (this.pos < this.limit) {
                    this.archive.seek(this.pos++);
                    n = this.archive.read();
                } else {
                    n = this.rear.read();
                }
            }
            return n;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = this.front.read(byArray, n, n2);
            if (0 <= n4) {
                n3 += n4;
            }
            this.archive.seek(this.pos);
            n4 = Math.min(n2 - n3, Math.max((int)(this.limit - this.pos), 0));
            this.archive.readFully(byArray, n + n3, n4);
            if (0 <= n4) {
                this.pos += (long)n4;
                n3 += n4;
            }
            if (0 <= (n4 = this.rear.read(byArray, n + n3, n2 - n3))) {
                n3 += n4;
            }
            if (0 < n3) {
                return n3;
            }
            return -1;
        }

        @Override
        public void close() {
            this.front = null;
            this.rear = null;
            this.archive = null;
        }

        public void cache(long l) throws IOException {
            int n = (int)Math.min(this.limit - this.pos, l - this.pos);
            byte[] byArray = new byte[n];
            if (0 < n) {
                this.archive.seek(this.pos);
                this.archive.readFully(byArray);
                this.front.add(byArray);
                this.pos += (long)n;
            }
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private RandomAccessFile archive;
        private Cache cache;
        private long start;
        private long pos;
        private long limit;

        public RandomAccessFileOutputStream(RandomAccessFile randomAccessFile, long l) throws IOException {
            this.archive = randomAccessFile;
            this.pos = this.start = this.archive.getFilePointer();
            this.limit = this.start + l;
            this.cache = new Cache();
        }

        @Override
        public void write(int n) throws IOException {
            if (this.pos < this.limit && this.cache.isEmpty()) {
                ++this.pos;
                this.archive.write(n);
            } else {
                this.cache.add(new byte[]{(byte)n});
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.pos + (long)n2 < this.limit && this.cache.isEmpty()) {
                this.pos += (long)n2;
                this.archive.write(byArray, n, n2);
            } else {
                this.cache.add(byArray, n, n2);
            }
        }

        @Override
        public void close() {
            this.archive = null;
        }
    }
}

