/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashAndChainedListSearch;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class LzssOutputStream
extends OutputStream {
    private static final int NEEDSEARCH = 0;
    public static final int NOMATCH = -1;
    private PostLzssEncoder encoder;
    private int DictionarySize;
    private int Threshold;
    private int MaxMatch;
    private byte[] TextBuffer;
    private int DictionaryLimit;
    private int writtenPos;
    private int putPos;
    private int searchPos;
    private int lastsearchret;
    private LzssSearchMethod method;

    private LzssOutputStream() {
    }

    public LzssOutputStream(PostLzssEncoder postLzssEncoder) {
        this(postLzssEncoder, HashAndChainedListSearch.class.getName(), new Object[0]);
    }

    public LzssOutputStream(PostLzssEncoder postLzssEncoder, String string) {
        this(postLzssEncoder, string, new Object[0]);
    }

    public LzssOutputStream(PostLzssEncoder postLzssEncoder, String string, Object[] objectArray) {
        this.DictionarySize = postLzssEncoder.getDictionarySize();
        this.MaxMatch = postLzssEncoder.getMaxMatch();
        this.Threshold = postLzssEncoder.getThreshold();
        this.encoder = postLzssEncoder;
        this.TextBuffer = new byte[this.DictionarySize * 2 + this.MaxMatch];
        this.writtenPos = this.DictionarySize;
        this.putPos = this.DictionarySize;
        this.searchPos = this.DictionarySize;
        this.DictionaryLimit = this.DictionarySize;
        this.lastsearchret = 0;
        Object[] objectArray2 = new Object[objectArray.length + 4];
        objectArray2[0] = new Integer(this.DictionarySize);
        objectArray2[1] = new Integer(this.MaxMatch);
        objectArray2[2] = new Integer(this.Threshold);
        objectArray2[3] = this.TextBuffer;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[4 + i] = objectArray[i];
        }
        try {
            this.method = (LzssSearchMethod)Factory.createInstance(string, objectArray2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException.getTargetException().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.TextBuffer[this.writtenPos++] = (byte)n;
        if (this.TextBuffer.length <= this.writtenPos) {
            this.encode(false);
            this.slide();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = this.TextBuffer.length - this.writtenPos;
            if (n4 - n3 < n5) {
                System.arraycopy(byArray, n3, this.TextBuffer, this.writtenPos, n4 - n3);
                this.writtenPos += n4 - n3;
                n3 = n4;
                continue;
            }
            System.arraycopy(byArray, n3, this.TextBuffer, this.writtenPos, n5);
            this.writtenPos += n5;
            n3 += n5;
            this.encode(false);
            this.slide();
        }
    }

    @Override
    public void flush() throws IOException {
        this.encode(false);
        if (this.DictionarySize * 2 <= this.putPos) {
            this.slide();
            if (this.searchPos < this.writtenPos) {
                this.encode(false);
            }
        }
        this.encoder.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.DictionarySize <= this.writtenPos) {
            this.encode(true);
            if (this.writtenPos <= this.searchPos) break;
            this.slide();
        }
        this.encoder.close();
        this.encoder = null;
        this.TextBuffer = null;
        this.method = null;
    }

    private void encode(boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block18: {
            n6 = Math.min(this.TextBuffer.length - this.MaxMatch, this.writtenPos - (bl ? 0 : this.method.putRequires()));
            if (this.searchPos < n6) {
                if (this.lastsearchret == 0) {
                    while (this.putPos < this.searchPos - 1) {
                        this.method.put(++this.putPos);
                        if (this.DictionarySize * 2 > this.putPos) continue;
                        return;
                    }
                    this.lastsearchret = this.method.searchAndPut(this.searchPos);
                }
                n5 = this.lastsearchret;
                n4 = LzssOutputStream.getMatchLen(n5);
                n3 = LzssOutputStream.getMatchPos(n5);
                if (this.writtenPos - this.searchPos < n4) {
                    n4 = this.writtenPos - this.searchPos;
                }
                while (true) {
                    n2 = n4;
                    n = this.searchPos - n3 - 1;
                    n5 = this.method.searchAndPut(++this.searchPos);
                    n4 = LzssOutputStream.getMatchLen(n5);
                    n3 = LzssOutputStream.getMatchPos(n5);
                    if (this.writtenPos - this.searchPos < n4) {
                        n4 = this.writtenPos - this.searchPos;
                    }
                    if (n2 < n4 || n2 < this.Threshold) {
                        this.encoder.writeCode(0xFF & this.TextBuffer[this.searchPos - 1]);
                        if (n6 > this.searchPos) continue;
                        this.putPos = this.searchPos;
                        this.lastsearchret = n5;
                        break block18;
                    }
                    this.encoder.writeCode(256 + n2 - this.Threshold);
                    this.encoder.writeOffset(n);
                    if (this.searchPos + --n2 >= n6) break;
                    while (0 < --n2) {
                        this.method.put(++this.searchPos);
                    }
                    n5 = this.method.searchAndPut(++this.searchPos);
                    n4 = LzssOutputStream.getMatchLen(n5);
                    n3 = LzssOutputStream.getMatchPos(n5);
                    if (this.writtenPos - this.searchPos >= n4) continue;
                    n4 = this.writtenPos - this.searchPos;
                }
                if (n6 < this.searchPos + n2) {
                    this.putPos = this.searchPos;
                    while (this.putPos < n6) {
                        this.method.put(++this.putPos);
                    }
                    this.searchPos += n2;
                    this.lastsearchret = 0;
                } else {
                    this.putPos = this.searchPos;
                    while (this.putPos < n6 - 1) {
                        this.method.put(++this.putPos);
                    }
                    ++this.putPos;
                    this.searchPos += n2;
                    this.lastsearchret = this.method.searchAndPut(this.searchPos);
                }
            }
        }
        n6 = Math.min(this.TextBuffer.length - this.MaxMatch, this.writtenPos);
        if (!bl && this.searchPos < n6) {
            if (this.lastsearchret == 0) {
                this.lastsearchret = this.method.search(this.searchPos, this.putPos);
            }
            n5 = this.lastsearchret;
            n4 = LzssOutputStream.getMatchLen(n5);
            n3 = LzssOutputStream.getMatchPos(n5);
            if (this.writtenPos - this.searchPos < n4) {
                n4 = this.writtenPos - this.searchPos;
            }
            while (this.searchPos < n6) {
                n2 = n4;
                n = this.searchPos - n3 - 1;
                n5 = this.method.search(++this.searchPos, this.putPos);
                n4 = LzssOutputStream.getMatchLen(n5);
                n3 = LzssOutputStream.getMatchPos(n5);
                if (this.writtenPos - this.searchPos < n4) {
                    n4 = this.writtenPos - this.searchPos;
                }
                if (n2 < n4 || n2 < this.Threshold) {
                    this.encoder.writeCode(0xFF & this.TextBuffer[this.searchPos - 1]);
                    continue;
                }
                this.encoder.writeCode(256 + n2 - this.Threshold);
                this.encoder.writeOffset(n);
                this.searchPos += n2 - 1;
                n5 = this.method.search(this.searchPos, this.putPos);
                n4 = LzssOutputStream.getMatchLen(n5);
                n3 = LzssOutputStream.getMatchPos(n5);
                if (this.writtenPos - this.searchPos >= n4) continue;
                n4 = this.writtenPos - this.searchPos;
            }
            this.lastsearchret = 0;
        }
    }

    private void slide() {
        int n;
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
        this.method.slide();
        if (this.lastsearchret != 0) {
            n = LzssOutputStream.getMatchLen(this.lastsearchret);
            int n2 = LzssOutputStream.getMatchPos(this.lastsearchret);
            this.lastsearchret = LzssOutputStream.createSearchReturn(n, n2 - this.DictionarySize);
        }
        this.writtenPos -= this.DictionarySize;
        this.searchPos -= this.DictionarySize;
        this.putPos -= this.DictionarySize;
        for (n = this.DictionaryLimit; n < this.writtenPos; ++n) {
            this.TextBuffer[n] = this.TextBuffer[n + this.DictionarySize];
        }
    }

    public static final int createSearchReturn(int n, int n2) {
        return n << 22 | n2;
    }

    public static final int getMatchLen(int n) {
        return n >> 22;
    }

    public static final int getMatchPos(int n) {
        if (0 <= n) {
            return n & 0x3FFFFF;
        }
        return -1;
    }
}

