/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh1Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 60;
    private static final int Threshold = 3;
    private BitOutputStream out;
    private DynamicHuffman huffman;
    private int[] offHiCode;
    private int[] offHiLen;

    private PostLh1Encoder() {
    }

    public PostLh1Encoder(OutputStream outputStream) {
        if (outputStream != null) {
            this.out = outputStream instanceof BitOutputStream ? (BitOutputStream)outputStream : new BitOutputStream(outputStream);
            this.huffman = new DynamicHuffman(314);
            this.offHiLen = PostLh1Encoder.createLenList();
            try {
                this.offHiCode = StaticHuffman.LenListToCodeList(this.offHiLen);
            }
            catch (BadHuffmanTableException badHuffmanTableException) {}
        } else {
            throw new NullPointerException("out");
        }
    }

    @Override
    public void writeCode(int n) throws IOException {
        int n2 = this.huffman.codeToNode(n);
        int n3 = 0;
        int n4 = 0;
        do {
            n3 >>>= 1;
            ++n4;
            if ((n2 & 1) == 0) continue;
            n3 |= Integer.MIN_VALUE;
        } while ((n2 = this.huffman.parentNode(n2)) != 0);
        this.out.writeBits(n4, n3 >> 32 - n4);
        this.huffman.update(n);
    }

    @Override
    public void writeOffset(int n) throws IOException {
        int n2 = n >> 6;
        this.out.writeBits(this.offHiLen[n2], this.offHiCode[n2]);
        this.out.writeBits(6, n);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.out = null;
        this.huffman = null;
        this.offHiLen = null;
        this.offHiCode = null;
    }

    @Override
    public int getDictionarySize() {
        return 4096;
    }

    @Override
    public int getMaxMatch() {
        return 60;
    }

    @Override
    public int getThreshold() {
        return 3;
    }

    private static int[] createLenList() {
        int[] nArray = new int[]{3, 1, 4, 12, 24, 48, 0};
        int[] nArray2 = new int[64];
        int n = 0;
        int n2 = nArray[n++];
        for (int i = 0; i < 64; ++i) {
            if (nArray[n] == i) {
                ++n;
            }
            nArray2[i] = ++n2;
        }
        return nArray2;
    }
}

