/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.CachedInputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class PreLz5Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 18;
    private static final int Threshold = 3;
    private InputStream in;
    private int position;
    private int matchPos;
    private int matchLen;
    private int flagByte;
    private int flagBit;
    private int markPosition;
    private int markMatchPos;
    private int markMatchLen;
    private int markFlagByte;
    private int markFlagBit;

    private PreLz5Decoder() {
    }

    public PreLz5Decoder(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        this.in = inputStream instanceof CachedInputStream ? (CachedInputStream)inputStream : new CachedInputStream(inputStream);
        this.position = 0;
        this.matchPos = 0;
        this.matchLen = 0;
        this.flagByte = 0;
        this.flagBit = 256;
        this.markPosition = 0;
        this.markMatchPos = 0;
        this.markMatchLen = 0;
        this.markFlagByte = 0;
        this.markFlagBit = 0;
    }

    @Override
    public int readCode() throws IOException {
        if (this.flagBit == 256) {
            this.flagByte = this.in.read();
            if (0 <= this.flagByte) {
                this.flagBit = 1;
            } else {
                throw new EOFException();
            }
        }
        if (0 != (this.flagByte & this.flagBit)) {
            this.flagBit <<= 1;
            ++this.position;
            int n = this.in.read();
            if (0 <= n) {
                return n;
            }
            throw new EOFException();
        }
        this.flagBit <<= 1;
        int n = this.in.read();
        int n2 = this.in.read();
        if (0 <= n) {
            this.matchPos = (n2 & 0xF0) << 4 | n;
            this.matchLen = n2 & 0xF;
            return this.matchLen | 0x100;
        }
        throw new EOFException();
    }

    @Override
    public int readOffset() throws IOException {
        int n = this.position - this.matchPos - 1 - 18 & 0xFFF;
        this.position += this.matchLen + 3;
        return n;
    }

    @Override
    public void mark(int n) {
        this.in.mark((n * 9 + 7) / 8 + 2);
        this.markPosition = this.position;
        this.markMatchLen = this.matchLen;
        this.markMatchPos = this.matchPos;
        this.markFlagByte = this.flagByte;
        this.markFlagBit = this.flagBit;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.position = this.markPosition;
        this.matchLen = this.markMatchLen;
        this.matchPos = this.markMatchPos;
        this.flagByte = this.markFlagByte;
        this.flagBit = this.markFlagBit;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.available() * 8 / 9 - 2, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public int getDictionarySize() {
        return 4096;
    }

    @Override
    public int getMaxMatch() {
        return 18;
    }

    @Override
    public int getThreshold() {
        return 3;
    }
}

