/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class PreLzsDecoder
implements PreLzssDecoder {
    private static final int DictionarySize = 2048;
    private static final int MaxMatch = 17;
    private static final int Threshold = 2;
    private static final int OffsetBits = Bits.len(2047);
    private static final int LengthBits = Bits.len(15);
    private BitInputStream in;
    private int position;
    private int matchOffset;
    private int matchLength;
    private int markPosition;
    private int markMatchOffset;
    private int markMatchLength;

    public PreLzsDecoder(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        this.in = inputStream instanceof BitInputStream ? (BitInputStream)inputStream : new BitInputStream(inputStream);
        this.position = 0;
        this.matchOffset = 0;
        this.matchLength = 0;
    }

    @Override
    public int readCode() throws IOException {
        try {
            if (this.in.readBoolean()) {
                ++this.position;
                return this.in.readBits(8);
            }
            this.matchOffset = this.in.readBits(OffsetBits);
            this.matchLength = this.in.readBits(LengthBits);
            return this.matchLength | 0x100;
        }
        catch (BitDataBrokenException bitDataBrokenException) {
            if (bitDataBrokenException.getCause() instanceof EOFException) {
                throw (EOFException)bitDataBrokenException.getCause();
            }
            throw bitDataBrokenException;
        }
    }

    @Override
    public int readOffset() throws IOException {
        int n = this.position - this.matchOffset - 1 - 17 & 0x7FF;
        this.position += this.matchLength + 2;
        return n;
    }

    @Override
    public void mark(int n) {
        this.in.mark((n * 9 + 7) / 8 + 1);
        this.markPosition = this.position;
        this.markMatchOffset = this.matchOffset;
        this.markMatchLength = this.matchLength;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.position = this.markPosition;
        this.matchOffset = this.markMatchOffset;
        this.matchLength = this.markMatchLength;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 9 - 2, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public int getDictionarySize() {
        return 2048;
    }

    @Override
    public int getMaxMatch() {
        return 17;
    }

    @Override
    public int getThreshold() {
        return 2;
    }
}

