(ns atena.gui.AddressPanel
  (:import (java.awt BorderLayout GridLayout GridBagLayout Insets
                     Font Color Dimension FlowLayout)
           (java.awt.event  ActionListener)
           (javax.swing JPanel JLabel JTextField JButton JCheckBox JOptionPane JScrollPane RowFilter)
           (javax.swing.border TitledBorder LineBorder)
           (javax.swing.event DocumentListener)
           (javax.swing.table DefaultTableCellRenderer TableColumn
                              TableCellRenderer DefaultTableModel
                              DefaultTableColumnModel TableRowSorter)
           (java.util.regex Pattern Matcher)
           (atena.gui AddressTable)
           )
  (:require [atena.utils.gridbaglayout])
  (:gen-class
   :extends javax.swing.JPanel
   :init init
   :post-init after-ctor
   :state state
   :methods [[setData [Object] void]
             [getAllData [] Object]
             [getSelectedData [] Object]
             [addSelectionChangedProc [Object] void]
             [update [String Object] void]
             [remove [String] void]
            ]
   ))


(defn -init []
  [[]
   (ref {:search-text (JTextField.)
         :table       (atena.gui.AddressTable.)
        })])

(defn -update
  [this
   uuid
   data]
  (let [{:keys [table]} @(.state this)
        model           (. table getModel)]
    (. model update uuid data)))

(defn -remove
  [this
   uuid]
  (let [{:keys [table]} @(.state this)
        model           (. table getModel)]
    (. model remove uuid)))

(defn -setData
  [this
   dataList]
  (let [{:keys [table]} @(.state this)]
    (. table setData dataList)
  ))

(defn -getAllData
  [this]
  (let [{:keys [table]} @(.state this)]
    (. table getAllData)))

(defn -getSelectedData
  [this]
  (let [{:keys [table]} @(.state this)]
    (. table getSelectedData)))

(defn -addSelectionChangedProc
  [this proc]
  (let [{:keys [table]} @(.state this)]
    (.addSelectionChangedProc table proc)))

(defn -after-ctor [this]
  (let [{:keys [search-text
                table]} @(.state this)]
    (doto this
      (.setLayout (GridBagLayout.))
      (.setBorder (TitledBorder. (LineBorder. Color/GRAY 2)
                                 "宛先一覧"
                                 TitledBorder/LEFT
                                 TitledBorder/TOP
                                 (Font. Font/MONOSPACED Font/BOLD 12)))
      (atena.utils.gridbaglayout/grid-bag-layout
       :insets (Insets. 5 5 5 5)
       :gridx 0, :gridy 0
       :anchor :WEST
       :fill :HORIZONTAL
       :weightx 1.0
       (doto (JPanel. (GridBagLayout.))
         (atena.utils.gridbaglayout/grid-bag-layout
          :insets (Insets. 5 5 5 5)
          :gridx 0, :gridy 0
          :anchor :WEST
          (JLabel. "検索：")
          :gridx 1, :gridy 0
          :weightx 1.0
          :fill :HORIZONTAL
          search-text))
       :gridx 0, :gridy 1
       :fill :BOTH
       :weighty 1.0
       (doto (JScrollPane. table)
         (.setSize (Dimension. 200 300)))))

    ;住所録検索
    (defn search
      [evt]
      (let [document (. evt getDocument)
            text     (.. document (getText 0 (. document getLength)))
            pattern  (try
                       (Pattern/compile text)
                       (catch Exception _ (Pattern/compile "")))
            model    (. table getModel)
            columns  (- (. table getColumnCount) 1)
            filter   (proxy [RowFilter] []
                       (include [entry]
                         (loop [i 1]
                           (let [value   (.. entry (getValue i) toString)
                                 matcher (. pattern matcher value)]
                             (if (. matcher find)
                                 true
                                 (if (= i columns)
                                     false
                                     (recur (+ i 1))))))))]
        (. table setFilter filter)))
    (doto (. search-text getDocument)
      (.addDocumentListener
        (proxy [DocumentListener] []
          (changedUpdate [evt])
          (insertUpdate [evt] (search evt))
          (removeUpdate [evt] (search evt)))))
     ))

