(ns atena.gui.AddressTable
  (:import (javax.swing JTable)
           (javax.swing.table TableRowSorter)
           (javax.swing.event ListSelectionListener)
           (atena.gui AddressTableColumnModel
                      AddressTableModel)
           )
  (:require [atena.utils.gridbaglayout])
  (:gen-class
   :extends javax.swing.JTable
   :init init
   :post-init after-ctor
   :state state
   :methods [[setData [Object] void]
             [getSelectedData [] Object]
             [getAllData [] Object]
             [getCheckedData [] Object]
             [addSelectionChangedProc [Object] void]
             [setFilter [Object] void]
             ]
   ))


(defn -init []
  [[]
   (ref {:model   (atena.gui.AddressTableModel.)
         :columns (atena.gui.AddressTableColumnModel.)})
   ])

(defn -setData
  ;宛先データ割り当て処理
  [this
   data-list]
  (let [model   (. this getModel)
        columns (. this getColumnModel)]
    ;行を全て削除する
    (. model setRowCount 0)
    ;データを全てテーブルにセット
    (loop [item (first data-list)
           list (rest data-list)]
      (if (= nil item)
          false
          (do
            (. model addRow
              (to-array [(if (= nil (item :checked)) false (item :checked))
              　         (item :family-name)
                         (item :first-names)
                         (item :honer)
                         (item :zcode)
                         (item :address)
                         (item :uuid)]))
            (recur (first list) (rest list)))))))

(defn getData
  [table
   proc]
  (let [model   (. table getModel)
        indexes (proc table)]
    (apply list (map (fn [index]
                       (. model getRowData index))
                     indexes))))

(defn -getSelectedData
  [this]
  (getData this (fn [table]
                  (map (fn [index]
                         (. table convertRowIndexToModel index))
                     (. table getSelectedRows)))))

(defn -getAllData
  [this]
  (getData this (fn [table]
                  (range (.. table getModel getRowCount)))))

(defn -getCheckedData
  [this]
  (getData this (fn [table]
                  (filter (fn [index]
                            (let [check (.. table getModel (getValueAt index 0))]
                              (= true check)))
                          (range (.. table getModel getRowCount))))))

(defn -addSelectionChangedProc
  [this
   proc]
  (let [table this]
    (doto (. table getSelectionModel)
      (.addListSelectionListener
        (proxy [ListSelectionListener] []
          (valueChanged [evt]
            (if (not (.getValueIsAdjusting evt))
                (proc table))))))))

(defn -setFilter
  [this filter]
  (let [sorter (. this getRowSorter)]
    (. sorter setRowFilter filter)))

(defn -after-ctor [this]
  (let [{:keys [model
                columns
               ]} @(.state this)]
    (doto this
      (.setModel model)
      (.setColumnModel columns)
      (.setAutoResizeMode JTable/AUTO_RESIZE_OFF)
      (.setFillsViewportHeight true)
      (.setRowSorter (TableRowSorter. model))
      (.removeColumn (. columns getUuidColumn))
      )))
